#[doc = "Register `UDCON` reader"]
pub struct R(crate::R<UDCON_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UDCON_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UDCON_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UDCON_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UDCON` writer"]
pub struct W(crate::W<UDCON_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UDCON_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UDCON_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UDCON_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DETACH` reader - Detach Bit"]
pub struct DETACH_R(crate::FieldReader<bool, bool>);
impl DETACH_R {
    pub(crate) fn new(bits: bool) -> Self {
        DETACH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DETACH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DETACH` writer - Detach Bit"]
pub struct DETACH_W<'a> {
    w: &'a mut W,
}
impl<'a> DETACH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `RMWKUP` reader - Remote Wake-up Bit"]
pub struct RMWKUP_R(crate::FieldReader<bool, bool>);
impl RMWKUP_R {
    pub(crate) fn new(bits: bool) -> Self {
        RMWKUP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RMWKUP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RMWKUP` writer - Remote Wake-up Bit"]
pub struct RMWKUP_W<'a> {
    w: &'a mut W,
}
impl<'a> RMWKUP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RSTCPU` reader - USB Reset CPU Bit"]
pub struct RSTCPU_R(crate::FieldReader<bool, bool>);
impl RSTCPU_R {
    pub(crate) fn new(bits: bool) -> Self {
        RSTCPU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSTCPU_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSTCPU` writer - USB Reset CPU Bit"]
pub struct RSTCPU_W<'a> {
    w: &'a mut W,
}
impl<'a> RSTCPU_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Detach Bit"]
    #[inline(always)]
    pub fn detach(&self) -> DETACH_R {
        DETACH_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Remote Wake-up Bit"]
    #[inline(always)]
    pub fn rmwkup(&self) -> RMWKUP_R {
        RMWKUP_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - USB Reset CPU Bit"]
    #[inline(always)]
    pub fn rstcpu(&self) -> RSTCPU_R {
        RSTCPU_R::new(((self.bits >> 2) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Detach Bit"]
    #[inline(always)]
    pub fn detach(&mut self) -> DETACH_W {
        DETACH_W { w: self }
    }
    #[doc = "Bit 1 - Remote Wake-up Bit"]
    #[inline(always)]
    pub fn rmwkup(&mut self) -> RMWKUP_W {
        RMWKUP_W { w: self }
    }
    #[doc = "Bit 2 - USB Reset CPU Bit"]
    #[inline(always)]
    pub fn rstcpu(&mut self) -> RSTCPU_W {
        RSTCPU_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Device Control Registers\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [udcon](index.html) module"]
pub struct UDCON_SPEC;
impl crate::RegisterSpec for UDCON_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [udcon::R](R) reader structure"]
impl crate::Readable for UDCON_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [udcon::W](W) writer structure"]
impl crate::Writable for UDCON_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UDCON to value 0"]
impl crate::Resettable for UDCON_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
