#[doc = "Register `PLLCSR` reader"]
pub struct R(crate::R<PLLCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PLLCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PLLCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PLLCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PLLCSR` writer"]
pub struct W(crate::W<PLLCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PLLCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PLLCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PLLCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PLOCK` reader - PLL Lock Status Bit"]
pub struct PLOCK_R(crate::FieldReader<bool, bool>);
impl PLOCK_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLOCK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLOCK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLE` reader - PLL Enable Bit"]
pub struct PLLE_R(crate::FieldReader<bool, bool>);
impl PLLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLE` writer - PLL Enable Bit"]
pub struct PLLE_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "PLL prescaler Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PLLP_A {
    #[doc = "3: Clock/4"]
    VAL_0X03 = 3,
    #[doc = "5: Clock/8"]
    VAL_0X05 = 5,
}
impl From<PLLP_A> for u8 {
    #[inline(always)]
    fn from(variant: PLLP_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PLLP` reader - PLL prescaler Bits"]
pub struct PLLP_R(crate::FieldReader<u8, PLLP_A>);
impl PLLP_R {
    pub(crate) fn new(bits: u8) -> Self {
        PLLP_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<PLLP_A> {
        match self.bits {
            3 => Some(PLLP_A::VAL_0X03),
            5 => Some(PLLP_A::VAL_0X05),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == PLLP_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == PLLP_A::VAL_0X05
    }
}
impl core::ops::Deref for PLLP_R {
    type Target = crate::FieldReader<u8, PLLP_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLP` writer - PLL prescaler Bits"]
pub struct PLLP_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PLLP_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Clock/4"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(PLLP_A::VAL_0X03)
    }
    #[doc = "Clock/8"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(PLLP_A::VAL_0X05)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 2)) | ((value as u8 & 0x07) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - PLL Lock Status Bit"]
    #[inline(always)]
    pub fn plock(&self) -> PLOCK_R {
        PLOCK_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - PLL Enable Bit"]
    #[inline(always)]
    pub fn plle(&self) -> PLLE_R {
        PLLE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 2:4 - PLL prescaler Bits"]
    #[inline(always)]
    pub fn pllp(&self) -> PLLP_R {
        PLLP_R::new(((self.bits >> 2) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bit 1 - PLL Enable Bit"]
    #[inline(always)]
    pub fn plle(&mut self) -> PLLE_W {
        PLLE_W { w: self }
    }
    #[doc = "Bits 2:4 - PLL prescaler Bits"]
    #[inline(always)]
    pub fn pllp(&mut self) -> PLLP_W {
        PLLP_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "PLL Status and Control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pllcsr](index.html) module"]
pub struct PLLCSR_SPEC;
impl crate::RegisterSpec for PLLCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pllcsr::R](R) reader structure"]
impl crate::Readable for PLLCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pllcsr::W](W) writer structure"]
impl crate::Writable for PLLCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PLLCSR to value 0"]
impl crate::Resettable for PLLCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
