#[doc = "Register `EXTENDED` reader"]
pub struct R(crate::R<EXTENDED_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EXTENDED_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EXTENDED_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EXTENDED_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EXTENDED` writer"]
pub struct W(crate::W<EXTENDED_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EXTENDED_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EXTENDED_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EXTENDED_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Brown-out Detector trigger level\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BODLEVEL_A {
    #[doc = "0: Brown-out detection level at VCC=4.3 V"]
    _4V3 = 0,
    #[doc = "1: Brown-out detection level at VCC=4.0 V"]
    _4V0 = 1,
    #[doc = "2: Brown-out detection level at VCC=3.6 V"]
    _3V6 = 2,
    #[doc = "3: Brown-out detection level at VCC=3.5 V"]
    _3V5 = 3,
    #[doc = "4: Brown-out detection level at VCC=3.0 V"]
    _3V0 = 4,
    #[doc = "5: Brown-out detection level at VCC=2.9 V"]
    _2V9 = 5,
    #[doc = "6: Brown-out detection level at VCC=2.7 V"]
    _2V7 = 6,
    #[doc = "7: Brown-out detection disabled"]
    DISABLED = 7,
}
impl From<BODLEVEL_A> for u8 {
    #[inline(always)]
    fn from(variant: BODLEVEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BODLEVEL` reader - Brown-out Detector trigger level"]
pub struct BODLEVEL_R(crate::FieldReader<u8, BODLEVEL_A>);
impl BODLEVEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        BODLEVEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BODLEVEL_A {
        match self.bits {
            0 => BODLEVEL_A::_4V3,
            1 => BODLEVEL_A::_4V0,
            2 => BODLEVEL_A::_3V6,
            3 => BODLEVEL_A::_3V5,
            4 => BODLEVEL_A::_3V0,
            5 => BODLEVEL_A::_2V9,
            6 => BODLEVEL_A::_2V7,
            7 => BODLEVEL_A::DISABLED,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `_4V3`"]
    #[inline(always)]
    pub fn is_4v3(&self) -> bool {
        **self == BODLEVEL_A::_4V3
    }
    #[doc = "Checks if the value of the field is `_4V0`"]
    #[inline(always)]
    pub fn is_4v0(&self) -> bool {
        **self == BODLEVEL_A::_4V0
    }
    #[doc = "Checks if the value of the field is `_3V6`"]
    #[inline(always)]
    pub fn is_3v6(&self) -> bool {
        **self == BODLEVEL_A::_3V6
    }
    #[doc = "Checks if the value of the field is `_3V5`"]
    #[inline(always)]
    pub fn is_3v5(&self) -> bool {
        **self == BODLEVEL_A::_3V5
    }
    #[doc = "Checks if the value of the field is `_3V0`"]
    #[inline(always)]
    pub fn is_3v0(&self) -> bool {
        **self == BODLEVEL_A::_3V0
    }
    #[doc = "Checks if the value of the field is `_2V9`"]
    #[inline(always)]
    pub fn is_2v9(&self) -> bool {
        **self == BODLEVEL_A::_2V9
    }
    #[doc = "Checks if the value of the field is `_2V7`"]
    #[inline(always)]
    pub fn is_2v7(&self) -> bool {
        **self == BODLEVEL_A::_2V7
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == BODLEVEL_A::DISABLED
    }
}
impl core::ops::Deref for BODLEVEL_R {
    type Target = crate::FieldReader<u8, BODLEVEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BODLEVEL` writer - Brown-out Detector trigger level"]
pub struct BODLEVEL_W<'a> {
    w: &'a mut W,
}
impl<'a> BODLEVEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BODLEVEL_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Brown-out detection level at VCC=4.3 V"]
    #[inline(always)]
    pub fn _4v3(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_4V3)
    }
    #[doc = "Brown-out detection level at VCC=4.0 V"]
    #[inline(always)]
    pub fn _4v0(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_4V0)
    }
    #[doc = "Brown-out detection level at VCC=3.6 V"]
    #[inline(always)]
    pub fn _3v6(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_3V6)
    }
    #[doc = "Brown-out detection level at VCC=3.5 V"]
    #[inline(always)]
    pub fn _3v5(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_3V5)
    }
    #[doc = "Brown-out detection level at VCC=3.0 V"]
    #[inline(always)]
    pub fn _3v0(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_3V0)
    }
    #[doc = "Brown-out detection level at VCC=2.9 V"]
    #[inline(always)]
    pub fn _2v9(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_2V9)
    }
    #[doc = "Brown-out detection level at VCC=2.7 V"]
    #[inline(always)]
    pub fn _2v7(self) -> &'a mut W {
        self.variant(BODLEVEL_A::_2V7)
    }
    #[doc = "Brown-out detection disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(BODLEVEL_A::DISABLED)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `HWBE` reader - Hardware Boot Enable"]
pub struct HWBE_R(crate::FieldReader<bool, bool>);
impl HWBE_R {
    pub(crate) fn new(bits: bool) -> Self {
        HWBE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HWBE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HWBE` writer - Hardware Boot Enable"]
pub struct HWBE_W<'a> {
    w: &'a mut W,
}
impl<'a> HWBE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Brown-out Detector trigger level"]
    #[inline(always)]
    pub fn bodlevel(&self) -> BODLEVEL_R {
        BODLEVEL_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Hardware Boot Enable"]
    #[inline(always)]
    pub fn hwbe(&self) -> HWBE_R {
        HWBE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Brown-out Detector trigger level"]
    #[inline(always)]
    pub fn bodlevel(&mut self) -> BODLEVEL_W {
        BODLEVEL_W { w: self }
    }
    #[doc = "Bit 3 - Hardware Boot Enable"]
    #[inline(always)]
    pub fn hwbe(&mut self) -> HWBE_W {
        HWBE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [extended](index.html) module"]
pub struct EXTENDED_SPEC;
impl crate::RegisterSpec for EXTENDED_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [extended::R](R) reader structure"]
impl crate::Readable for EXTENDED_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [extended::W](W) writer structure"]
impl crate::Writable for EXTENDED_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EXTENDED to value 0"]
impl crate::Resettable for EXTENDED_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
