#[doc = "Register `TCCR1B` reader"]
pub struct R(crate::R<TCCR1B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR1B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR1B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR1B` writer"]
pub struct W(crate::W<TCCR1B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR1B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR1B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select1 bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS1_A {
    #[doc = "0: No Clock Source (Stopped)"]
    VAL_0X00 = 0,
    #[doc = "1: Running, No Prescaling"]
    VAL_0X01 = 1,
    #[doc = "2: Running, CLK/8"]
    VAL_0X02 = 2,
    #[doc = "3: Running, CLK/64"]
    VAL_0X03 = 3,
    #[doc = "4: Running, CLK/256"]
    VAL_0X04 = 4,
    #[doc = "5: Running, CLK/1024"]
    VAL_0X05 = 5,
    #[doc = "6: Running, ExtClk Tx Falling Edge"]
    VAL_0X06 = 6,
    #[doc = "7: Running, ExtClk Tx Rising Edge"]
    VAL_0X07 = 7,
}
impl From<CS1_A> for u8 {
    #[inline(always)]
    fn from(variant: CS1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS1` reader - Clock Select1 bits"]
pub struct CS1_R(crate::FieldReader<u8, CS1_A>);
impl CS1_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS1_A {
        match self.bits {
            0 => CS1_A::VAL_0X00,
            1 => CS1_A::VAL_0X01,
            2 => CS1_A::VAL_0X02,
            3 => CS1_A::VAL_0X03,
            4 => CS1_A::VAL_0X04,
            5 => CS1_A::VAL_0X05,
            6 => CS1_A::VAL_0X06,
            7 => CS1_A::VAL_0X07,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == CS1_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == CS1_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == CS1_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == CS1_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == CS1_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == CS1_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == CS1_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == CS1_A::VAL_0X07
    }
}
impl core::ops::Deref for CS1_R {
    type Target = crate::FieldReader<u8, CS1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS1` writer - Clock Select1 bits"]
pub struct CS1_W<'a> {
    w: &'a mut W,
}
impl<'a> CS1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No Clock Source (Stopped)"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X00)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X01)
    }
    #[doc = "Running, CLK/8"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X02)
    }
    #[doc = "Running, CLK/64"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X03)
    }
    #[doc = "Running, CLK/256"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X04)
    }
    #[doc = "Running, CLK/1024"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X05)
    }
    #[doc = "Running, ExtClk Tx Falling Edge"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X06)
    }
    #[doc = "Running, ExtClk Tx Rising Edge"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(CS1_A::VAL_0X07)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `WGM1` reader - Waveform Generation Mode"]
pub struct WGM1_R(crate::FieldReader<u8, u8>);
impl WGM1_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM1` writer - Waveform Generation Mode"]
pub struct WGM1_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u8 & 0x03) << 3);
        self.w
    }
}
#[doc = "Field `ICES1` reader - Input Capture 1 Edge Select"]
pub struct ICES1_R(crate::FieldReader<bool, bool>);
impl ICES1_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICES1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICES1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICES1` writer - Input Capture 1 Edge Select"]
pub struct ICES1_W<'a> {
    w: &'a mut W,
}
impl<'a> ICES1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ICNC1` reader - Input Capture 1 Noise Canceler"]
pub struct ICNC1_R(crate::FieldReader<bool, bool>);
impl ICNC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICNC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICNC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICNC1` writer - Input Capture 1 Noise Canceler"]
pub struct ICNC1_W<'a> {
    w: &'a mut W,
}
impl<'a> ICNC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Clock Select1 bits"]
    #[inline(always)]
    pub fn cs1(&self) -> CS1_R {
        CS1_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm1(&self) -> WGM1_R {
        WGM1_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Input Capture 1 Edge Select"]
    #[inline(always)]
    pub fn ices1(&self) -> ICES1_R {
        ICES1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Input Capture 1 Noise Canceler"]
    #[inline(always)]
    pub fn icnc1(&self) -> ICNC1_R {
        ICNC1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Clock Select1 bits"]
    #[inline(always)]
    pub fn cs1(&mut self) -> CS1_W {
        CS1_W { w: self }
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm1(&mut self) -> WGM1_W {
        WGM1_W { w: self }
    }
    #[doc = "Bit 6 - Input Capture 1 Edge Select"]
    #[inline(always)]
    pub fn ices1(&mut self) -> ICES1_W {
        ICES1_W { w: self }
    }
    #[doc = "Bit 7 - Input Capture 1 Noise Canceler"]
    #[inline(always)]
    pub fn icnc1(&mut self) -> ICNC1_W {
        ICNC1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter1 Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr1b](index.html) module"]
pub struct TCCR1B_SPEC;
impl crate::RegisterSpec for TCCR1B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr1b::R](R) reader structure"]
impl crate::Readable for TCCR1B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr1b::W](W) writer structure"]
impl crate::Writable for TCCR1B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR1B to value 0"]
impl crate::Resettable for TCCR1B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
