#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Special Function IO Register"]
    pub sfior: crate::Reg<sfior::SFIOR_SPEC>,
    _reserved1: [u8; 0x0f],
    #[doc = "0x10 - Asynchronus Status Register"]
    pub assr: crate::Reg<assr::ASSR_SPEC>,
    #[doc = "0x11 - Output Compare Register"]
    pub ocr0: crate::Reg<ocr0::OCR0_SPEC>,
    #[doc = "0x12 - Timer/Counter Register"]
    pub tcnt0: crate::Reg<tcnt0::TCNT0_SPEC>,
    #[doc = "0x13 - Timer/Counter Control Register"]
    pub tccr0: crate::Reg<tccr0::TCCR0_SPEC>,
    _reserved5: [u8; 0x02],
    #[doc = "0x16 - Timer/Counter Interrupt Flag register"]
    pub tifr: crate::Reg<tifr::TIFR_SPEC>,
    #[doc = "0x17 - Timer/Counter Interrupt Mask Register"]
    pub timsk: crate::Reg<timsk::TIMSK_SPEC>,
}
#[doc = "ASSR register accessor: an alias for `Reg<ASSR_SPEC>`"]
pub type ASSR = crate::Reg<assr::ASSR_SPEC>;
#[doc = "Asynchronus Status Register"]
pub mod assr;
#[doc = "OCR0 register accessor: an alias for `Reg<OCR0_SPEC>`"]
pub type OCR0 = crate::Reg<ocr0::OCR0_SPEC>;
#[doc = "Output Compare Register"]
pub mod ocr0;
#[doc = "SFIOR register accessor: an alias for `Reg<SFIOR_SPEC>`"]
pub type SFIOR = crate::Reg<sfior::SFIOR_SPEC>;
#[doc = "Special Function IO Register"]
pub mod sfior;
#[doc = "TCCR0 register accessor: an alias for `Reg<TCCR0_SPEC>`"]
pub type TCCR0 = crate::Reg<tccr0::TCCR0_SPEC>;
#[doc = "Timer/Counter Control Register"]
pub mod tccr0;
#[doc = "TCNT0 register accessor: an alias for `Reg<TCNT0_SPEC>`"]
pub type TCNT0 = crate::Reg<tcnt0::TCNT0_SPEC>;
#[doc = "Timer/Counter Register"]
pub mod tcnt0;
#[doc = "TIFR register accessor: an alias for `Reg<TIFR_SPEC>`"]
pub type TIFR = crate::Reg<tifr::TIFR_SPEC>;
#[doc = "Timer/Counter Interrupt Flag register"]
pub mod tifr;
#[doc = "TIMSK register accessor: an alias for `Reg<TIMSK_SPEC>`"]
pub type TIMSK = crate::Reg<timsk::TIMSK_SPEC>;
#[doc = "Timer/Counter Interrupt Mask Register"]
pub mod timsk;
