#[doc = "Register `MCUCSR` reader"]
pub struct R(crate::R<MCUCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCUCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCUCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCUCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MCUCSR` writer"]
pub struct W(crate::W<MCUCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MCUCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MCUCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MCUCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `JTRF` reader - JTAG Reset Flag"]
pub struct JTRF_R(crate::FieldReader<bool, bool>);
impl JTRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        JTRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for JTRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `JTRF` writer - JTAG Reset Flag"]
pub struct JTRF_W<'a> {
    w: &'a mut W,
}
impl<'a> JTRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `JTD` reader - JTAG Interface Disable"]
pub struct JTD_R(crate::FieldReader<bool, bool>);
impl JTD_R {
    pub(crate) fn new(bits: bool) -> Self {
        JTD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for JTD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `JTD` writer - JTAG Interface Disable"]
pub struct JTD_W<'a> {
    w: &'a mut W,
}
impl<'a> JTD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 4 - JTAG Reset Flag"]
    #[inline(always)]
    pub fn jtrf(&self) -> JTRF_R {
        JTRF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 7 - JTAG Interface Disable"]
    #[inline(always)]
    pub fn jtd(&self) -> JTD_R {
        JTD_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 4 - JTAG Reset Flag"]
    #[inline(always)]
    pub fn jtrf(&mut self) -> JTRF_W {
        JTRF_W { w: self }
    }
    #[doc = "Bit 7 - JTAG Interface Disable"]
    #[inline(always)]
    pub fn jtd(&mut self) -> JTD_W {
        JTD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "MCU Control And Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mcucsr](index.html) module"]
pub struct MCUCSR_SPEC;
impl crate::RegisterSpec for MCUCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mcucsr::R](R) reader structure"]
impl crate::Readable for MCUCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mcucsr::W](W) writer structure"]
impl crate::Writable for MCUCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MCUCSR to value 0"]
impl crate::Resettable for MCUCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
