#[doc = "Register `EECR` reader"]
pub struct R(crate::R<EECR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EECR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EECR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EECR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EECR` writer"]
pub struct W(crate::W<EECR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EECR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EECR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EECR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EERE` reader - EEPROM Read Enable"]
pub struct EERE_R(crate::FieldReader<bool, bool>);
impl EERE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EERE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EERE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EERE` writer - EEPROM Read Enable"]
pub struct EERE_W<'a> {
    w: &'a mut W,
}
impl<'a> EERE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `EEWE` reader - EEPROM Write Enable"]
pub struct EEWE_R(crate::FieldReader<bool, bool>);
impl EEWE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EEWE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EEWE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEWE` writer - EEPROM Write Enable"]
pub struct EEWE_W<'a> {
    w: &'a mut W,
}
impl<'a> EEWE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `EEMWE` reader - EEPROM Master Write Enable"]
pub struct EEMWE_R(crate::FieldReader<bool, bool>);
impl EEMWE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EEMWE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EEMWE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEMWE` writer - EEPROM Master Write Enable"]
pub struct EEMWE_W<'a> {
    w: &'a mut W,
}
impl<'a> EEMWE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `EERIE` reader - EEPROM Ready Interrupt Enable"]
pub struct EERIE_R(crate::FieldReader<bool, bool>);
impl EERIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EERIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EERIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EERIE` writer - EEPROM Ready Interrupt Enable"]
pub struct EERIE_W<'a> {
    w: &'a mut W,
}
impl<'a> EERIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - EEPROM Read Enable"]
    #[inline(always)]
    pub fn eere(&self) -> EERE_R {
        EERE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - EEPROM Write Enable"]
    #[inline(always)]
    pub fn eewe(&self) -> EEWE_R {
        EEWE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - EEPROM Master Write Enable"]
    #[inline(always)]
    pub fn eemwe(&self) -> EEMWE_R {
        EEMWE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - EEPROM Ready Interrupt Enable"]
    #[inline(always)]
    pub fn eerie(&self) -> EERIE_R {
        EERIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - EEPROM Read Enable"]
    #[inline(always)]
    pub fn eere(&mut self) -> EERE_W {
        EERE_W { w: self }
    }
    #[doc = "Bit 1 - EEPROM Write Enable"]
    #[inline(always)]
    pub fn eewe(&mut self) -> EEWE_W {
        EEWE_W { w: self }
    }
    #[doc = "Bit 2 - EEPROM Master Write Enable"]
    #[inline(always)]
    pub fn eemwe(&mut self) -> EEMWE_W {
        EEMWE_W { w: self }
    }
    #[doc = "Bit 3 - EEPROM Ready Interrupt Enable"]
    #[inline(always)]
    pub fn eerie(&mut self) -> EERIE_W {
        EERIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EEPROM Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [eecr](index.html) module"]
pub struct EECR_SPEC;
impl crate::RegisterSpec for EECR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [eecr::R](R) reader structure"]
impl crate::Readable for EECR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [eecr::W](W) writer structure"]
impl crate::Writable for EECR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EECR to value 0"]
impl crate::Resettable for EECR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
