#[doc = "Register `CTRLB` reader"]
pub struct R(crate::R<CTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLB` writer"]
pub struct W(crate::W<CTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `MPCM` reader - Multi-processor Communication Mode"]
pub struct MPCM_R(crate::FieldReader<bool, bool>);
impl MPCM_R {
    pub(crate) fn new(bits: bool) -> Self {
        MPCM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MPCM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MPCM` writer - Multi-processor Communication Mode"]
pub struct MPCM_W<'a> {
    w: &'a mut W,
}
impl<'a> MPCM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Receiver Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum RXMODE_A {
    #[doc = "0: Normal mode"]
    NORMAL = 0,
    #[doc = "1: CLK2x mode"]
    CLK2X = 1,
    #[doc = "2: Generic autobaud mode"]
    GENAUTO = 2,
    #[doc = "3: LIN constrained autobaud mode"]
    LINAUTO = 3,
}
impl From<RXMODE_A> for u8 {
    #[inline(always)]
    fn from(variant: RXMODE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `RXMODE` reader - Receiver Mode"]
pub struct RXMODE_R(crate::FieldReader<u8, RXMODE_A>);
impl RXMODE_R {
    pub(crate) fn new(bits: u8) -> Self {
        RXMODE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> RXMODE_A {
        match self.bits {
            0 => RXMODE_A::NORMAL,
            1 => RXMODE_A::CLK2X,
            2 => RXMODE_A::GENAUTO,
            3 => RXMODE_A::LINAUTO,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL`"]
    #[inline(always)]
    pub fn is_normal(&self) -> bool {
        **self == RXMODE_A::NORMAL
    }
    #[doc = "Checks if the value of the field is `CLK2X`"]
    #[inline(always)]
    pub fn is_clk2x(&self) -> bool {
        **self == RXMODE_A::CLK2X
    }
    #[doc = "Checks if the value of the field is `GENAUTO`"]
    #[inline(always)]
    pub fn is_genauto(&self) -> bool {
        **self == RXMODE_A::GENAUTO
    }
    #[doc = "Checks if the value of the field is `LINAUTO`"]
    #[inline(always)]
    pub fn is_linauto(&self) -> bool {
        **self == RXMODE_A::LINAUTO
    }
}
impl core::ops::Deref for RXMODE_R {
    type Target = crate::FieldReader<u8, RXMODE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXMODE` writer - Receiver Mode"]
pub struct RXMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXMODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: RXMODE_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal mode"]
    #[inline(always)]
    pub fn normal(self) -> &'a mut W {
        self.variant(RXMODE_A::NORMAL)
    }
    #[doc = "CLK2x mode"]
    #[inline(always)]
    pub fn clk2x(self) -> &'a mut W {
        self.variant(RXMODE_A::CLK2X)
    }
    #[doc = "Generic autobaud mode"]
    #[inline(always)]
    pub fn genauto(self) -> &'a mut W {
        self.variant(RXMODE_A::GENAUTO)
    }
    #[doc = "LIN constrained autobaud mode"]
    #[inline(always)]
    pub fn linauto(self) -> &'a mut W {
        self.variant(RXMODE_A::LINAUTO)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "Field `ODME` reader - Open Drain Mode Enable"]
pub struct ODME_R(crate::FieldReader<bool, bool>);
impl ODME_R {
    pub(crate) fn new(bits: bool) -> Self {
        ODME_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ODME_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ODME` writer - Open Drain Mode Enable"]
pub struct ODME_W<'a> {
    w: &'a mut W,
}
impl<'a> ODME_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `SFDEN` reader - Start Frame Detection Enable"]
pub struct SFDEN_R(crate::FieldReader<bool, bool>);
impl SFDEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SFDEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFDEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFDEN` writer - Start Frame Detection Enable"]
pub struct SFDEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SFDEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `TXEN` reader - Transmitter Enable"]
pub struct TXEN_R(crate::FieldReader<bool, bool>);
impl TXEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXEN` writer - Transmitter Enable"]
pub struct TXEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TXEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXEN` reader - Reciever enable"]
pub struct RXEN_R(crate::FieldReader<bool, bool>);
impl RXEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXEN` writer - Reciever enable"]
pub struct RXEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RXEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Multi-processor Communication Mode"]
    #[inline(always)]
    pub fn mpcm(&self) -> MPCM_R {
        MPCM_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Receiver Mode"]
    #[inline(always)]
    pub fn rxmode(&self) -> RXMODE_R {
        RXMODE_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bit 3 - Open Drain Mode Enable"]
    #[inline(always)]
    pub fn odme(&self) -> ODME_R {
        ODME_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Start Frame Detection Enable"]
    #[inline(always)]
    pub fn sfden(&self) -> SFDEN_R {
        SFDEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen(&self) -> TXEN_R {
        TXEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Reciever enable"]
    #[inline(always)]
    pub fn rxen(&self) -> RXEN_R {
        RXEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Multi-processor Communication Mode"]
    #[inline(always)]
    pub fn mpcm(&mut self) -> MPCM_W {
        MPCM_W { w: self }
    }
    #[doc = "Bits 1:2 - Receiver Mode"]
    #[inline(always)]
    pub fn rxmode(&mut self) -> RXMODE_W {
        RXMODE_W { w: self }
    }
    #[doc = "Bit 3 - Open Drain Mode Enable"]
    #[inline(always)]
    pub fn odme(&mut self) -> ODME_W {
        ODME_W { w: self }
    }
    #[doc = "Bit 4 - Start Frame Detection Enable"]
    #[inline(always)]
    pub fn sfden(&mut self) -> SFDEN_W {
        SFDEN_W { w: self }
    }
    #[doc = "Bit 6 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen(&mut self) -> TXEN_W {
        TXEN_W { w: self }
    }
    #[doc = "Bit 7 - Reciever enable"]
    #[inline(always)]
    pub fn rxen(&mut self) -> RXEN_W {
        RXEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlb](index.html) module"]
pub struct CTRLB_SPEC;
impl crate::RegisterSpec for CTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrlb::R](R) reader structure"]
impl crate::Readable for CTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrlb::W](W) writer structure"]
impl crate::Writable for CTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLB to value 0"]
impl crate::Resettable for CTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
