#[doc = "Register `TXDATAH` reader"]
pub struct R(crate::R<TXDATAH_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TXDATAH_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TXDATAH_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TXDATAH_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TXDATAH` writer"]
pub struct W(crate::W<TXDATAH_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TXDATAH_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TXDATAH_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TXDATAH_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DATA8` reader - Transmit Data Register (CHSIZE=9bit)"]
pub struct DATA8_R(crate::FieldReader<bool, bool>);
impl DATA8_R {
    pub(crate) fn new(bits: bool) -> Self {
        DATA8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DATA8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DATA8` writer - Transmit Data Register (CHSIZE=9bit)"]
pub struct DATA8_W<'a> {
    w: &'a mut W,
}
impl<'a> DATA8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmit Data Register (CHSIZE=9bit)"]
    #[inline(always)]
    pub fn data8(&self) -> DATA8_R {
        DATA8_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmit Data Register (CHSIZE=9bit)"]
    #[inline(always)]
    pub fn data8(&mut self) -> DATA8_W {
        DATA8_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transmit Data High Byte\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txdatah](index.html) module"]
pub struct TXDATAH_SPEC;
impl crate::RegisterSpec for TXDATAH_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [txdatah::R](R) reader structure"]
impl crate::Readable for TXDATAH_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [txdatah::W](W) writer structure"]
impl crate::Writable for TXDATAH_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TXDATAH to value 0"]
impl crate::Resettable for TXDATAH_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
