#[doc = "Register `RXDATAH` reader"]
pub struct R(crate::R<RXDATAH_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RXDATAH_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RXDATAH_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RXDATAH_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `DATA8` reader - Receiver Data Register"]
pub struct DATA8_R(crate::FieldReader<bool, bool>);
impl DATA8_R {
    pub(crate) fn new(bits: bool) -> Self {
        DATA8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DATA8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PERR` reader - Parity Error"]
pub struct PERR_R(crate::FieldReader<bool, bool>);
impl PERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        PERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FERR` reader - Frame Error"]
pub struct FERR_R(crate::FieldReader<bool, bool>);
impl FERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        FERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUFOVF` reader - Buffer Overflow"]
pub struct BUFOVF_R(crate::FieldReader<bool, bool>);
impl BUFOVF_R {
    pub(crate) fn new(bits: bool) -> Self {
        BUFOVF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUFOVF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIF` reader - Receive Complete Interrupt Flag"]
pub struct RXCIF_R(crate::FieldReader<bool, bool>);
impl RXCIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - Receiver Data Register"]
    #[inline(always)]
    pub fn data8(&self) -> DATA8_R {
        DATA8_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Parity Error"]
    #[inline(always)]
    pub fn perr(&self) -> PERR_R {
        PERR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Frame Error"]
    #[inline(always)]
    pub fn ferr(&self) -> FERR_R {
        FERR_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Buffer Overflow"]
    #[inline(always)]
    pub fn bufovf(&self) -> BUFOVF_R {
        BUFOVF_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Receive Complete Interrupt Flag"]
    #[inline(always)]
    pub fn rxcif(&self) -> RXCIF_R {
        RXCIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
#[doc = "Receive Data High Byte\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxdatah](index.html) module"]
pub struct RXDATAH_SPEC;
impl crate::RegisterSpec for RXDATAH_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [rxdatah::R](R) reader structure"]
impl crate::Readable for RXDATAH_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets RXDATAH to value 0"]
impl crate::Resettable for RXDATAH_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
