#[doc = "Register `SEQCTRL1` reader"]
pub struct R(crate::R<SEQCTRL1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SEQCTRL1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SEQCTRL1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SEQCTRL1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SEQCTRL1` writer"]
pub struct W(crate::W<SEQCTRL1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SEQCTRL1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SEQCTRL1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SEQCTRL1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Sequential Selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SEQSEL1_A {
    #[doc = "0: Sequential logic disabled"]
    DISABLE = 0,
    #[doc = "1: D FlipFlop"]
    DFF = 1,
    #[doc = "2: JK FlipFlop"]
    JK = 2,
    #[doc = "3: D Latch"]
    LATCH = 3,
    #[doc = "4: RS Latch"]
    RS = 4,
}
impl From<SEQSEL1_A> for u8 {
    #[inline(always)]
    fn from(variant: SEQSEL1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SEQSEL1` reader - Sequential Selection"]
pub struct SEQSEL1_R(crate::FieldReader<u8, SEQSEL1_A>);
impl SEQSEL1_R {
    pub(crate) fn new(bits: u8) -> Self {
        SEQSEL1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<SEQSEL1_A> {
        match self.bits {
            0 => Some(SEQSEL1_A::DISABLE),
            1 => Some(SEQSEL1_A::DFF),
            2 => Some(SEQSEL1_A::JK),
            3 => Some(SEQSEL1_A::LATCH),
            4 => Some(SEQSEL1_A::RS),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLE`"]
    #[inline(always)]
    pub fn is_disable(&self) -> bool {
        **self == SEQSEL1_A::DISABLE
    }
    #[doc = "Checks if the value of the field is `DFF`"]
    #[inline(always)]
    pub fn is_dff(&self) -> bool {
        **self == SEQSEL1_A::DFF
    }
    #[doc = "Checks if the value of the field is `JK`"]
    #[inline(always)]
    pub fn is_jk(&self) -> bool {
        **self == SEQSEL1_A::JK
    }
    #[doc = "Checks if the value of the field is `LATCH`"]
    #[inline(always)]
    pub fn is_latch(&self) -> bool {
        **self == SEQSEL1_A::LATCH
    }
    #[doc = "Checks if the value of the field is `RS`"]
    #[inline(always)]
    pub fn is_rs(&self) -> bool {
        **self == SEQSEL1_A::RS
    }
}
impl core::ops::Deref for SEQSEL1_R {
    type Target = crate::FieldReader<u8, SEQSEL1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SEQSEL1` writer - Sequential Selection"]
pub struct SEQSEL1_W<'a> {
    w: &'a mut W,
}
impl<'a> SEQSEL1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SEQSEL1_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Sequential logic disabled"]
    #[inline(always)]
    pub fn disable(self) -> &'a mut W {
        self.variant(SEQSEL1_A::DISABLE)
    }
    #[doc = "D FlipFlop"]
    #[inline(always)]
    pub fn dff(self) -> &'a mut W {
        self.variant(SEQSEL1_A::DFF)
    }
    #[doc = "JK FlipFlop"]
    #[inline(always)]
    pub fn jk(self) -> &'a mut W {
        self.variant(SEQSEL1_A::JK)
    }
    #[doc = "D Latch"]
    #[inline(always)]
    pub fn latch(self) -> &'a mut W {
        self.variant(SEQSEL1_A::LATCH)
    }
    #[doc = "RS Latch"]
    #[inline(always)]
    pub fn rs(self) -> &'a mut W {
        self.variant(SEQSEL1_A::RS)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Sequential Selection"]
    #[inline(always)]
    pub fn seqsel1(&self) -> SEQSEL1_R {
        SEQSEL1_R::new((self.bits & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Sequential Selection"]
    #[inline(always)]
    pub fn seqsel1(&mut self) -> SEQSEL1_W {
        SEQSEL1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Sequential Control 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [seqctrl1](index.html) module"]
pub struct SEQCTRL1_SPEC;
impl crate::RegisterSpec for SEQCTRL1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [seqctrl1::R](R) reader structure"]
impl crate::Readable for SEQCTRL1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [seqctrl1::W](W) writer structure"]
impl crate::Writable for SEQCTRL1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SEQCTRL1 to value 0"]
impl crate::Resettable for SEQCTRL1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
