#[doc = "Register `LUT3CTRLA` reader"]
pub struct R(crate::R<LUT3CTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LUT3CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LUT3CTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LUT3CTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LUT3CTRLA` writer"]
pub struct W(crate::W<LUT3CTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LUT3CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LUT3CTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LUT3CTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ENABLE` reader - LUT Enable"]
pub struct ENABLE_R(crate::FieldReader<bool, bool>);
impl ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENABLE` writer - LUT Enable"]
pub struct ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Clock Source Selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CLKSRC_A {
    #[doc = "0: CLK_PER is clocking the LUT"]
    CLKPER = 0,
    #[doc = "1: IN\\[2\\]
is clocking the LUT"]
    IN2 = 1,
    #[doc = "4: 20MHz oscillator before prescaler is clocking the LUT"]
    OSC20M = 4,
    #[doc = "5: 32kHz oscillator is clocking the LUT"]
    OSCULP32K = 5,
    #[doc = "6: 32kHz oscillator after DIV32 is clocking the LUT"]
    OSCULP1K = 6,
}
impl From<CLKSRC_A> for u8 {
    #[inline(always)]
    fn from(variant: CLKSRC_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CLKSRC` reader - Clock Source Selection"]
pub struct CLKSRC_R(crate::FieldReader<u8, CLKSRC_A>);
impl CLKSRC_R {
    pub(crate) fn new(bits: u8) -> Self {
        CLKSRC_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CLKSRC_A> {
        match self.bits {
            0 => Some(CLKSRC_A::CLKPER),
            1 => Some(CLKSRC_A::IN2),
            4 => Some(CLKSRC_A::OSC20M),
            5 => Some(CLKSRC_A::OSCULP32K),
            6 => Some(CLKSRC_A::OSCULP1K),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `CLKPER`"]
    #[inline(always)]
    pub fn is_clkper(&self) -> bool {
        **self == CLKSRC_A::CLKPER
    }
    #[doc = "Checks if the value of the field is `IN2`"]
    #[inline(always)]
    pub fn is_in2(&self) -> bool {
        **self == CLKSRC_A::IN2
    }
    #[doc = "Checks if the value of the field is `OSC20M`"]
    #[inline(always)]
    pub fn is_osc20m(&self) -> bool {
        **self == CLKSRC_A::OSC20M
    }
    #[doc = "Checks if the value of the field is `OSCULP32K`"]
    #[inline(always)]
    pub fn is_osculp32k(&self) -> bool {
        **self == CLKSRC_A::OSCULP32K
    }
    #[doc = "Checks if the value of the field is `OSCULP1K`"]
    #[inline(always)]
    pub fn is_osculp1k(&self) -> bool {
        **self == CLKSRC_A::OSCULP1K
    }
}
impl core::ops::Deref for CLKSRC_R {
    type Target = crate::FieldReader<u8, CLKSRC_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKSRC` writer - Clock Source Selection"]
pub struct CLKSRC_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKSRC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CLKSRC_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "CLK_PER is clocking the LUT"]
    #[inline(always)]
    pub fn clkper(self) -> &'a mut W {
        self.variant(CLKSRC_A::CLKPER)
    }
    #[doc = "IN\\[2\\]
is clocking the LUT"]
    #[inline(always)]
    pub fn in2(self) -> &'a mut W {
        self.variant(CLKSRC_A::IN2)
    }
    #[doc = "20MHz oscillator before prescaler is clocking the LUT"]
    #[inline(always)]
    pub fn osc20m(self) -> &'a mut W {
        self.variant(CLKSRC_A::OSC20M)
    }
    #[doc = "32kHz oscillator is clocking the LUT"]
    #[inline(always)]
    pub fn osculp32k(self) -> &'a mut W {
        self.variant(CLKSRC_A::OSCULP32K)
    }
    #[doc = "32kHz oscillator after DIV32 is clocking the LUT"]
    #[inline(always)]
    pub fn osculp1k(self) -> &'a mut W {
        self.variant(CLKSRC_A::OSCULP1K)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 1)) | ((value as u8 & 0x07) << 1);
        self.w
    }
}
#[doc = "Filter Selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum FILTSEL_A {
    #[doc = "0: Filter disabled"]
    DISABLE = 0,
    #[doc = "1: Synchronizer enabled"]
    SYNCH = 1,
    #[doc = "2: Filter enabled"]
    FILTER = 2,
}
impl From<FILTSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: FILTSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `FILTSEL` reader - Filter Selection"]
pub struct FILTSEL_R(crate::FieldReader<u8, FILTSEL_A>);
impl FILTSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        FILTSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<FILTSEL_A> {
        match self.bits {
            0 => Some(FILTSEL_A::DISABLE),
            1 => Some(FILTSEL_A::SYNCH),
            2 => Some(FILTSEL_A::FILTER),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLE`"]
    #[inline(always)]
    pub fn is_disable(&self) -> bool {
        **self == FILTSEL_A::DISABLE
    }
    #[doc = "Checks if the value of the field is `SYNCH`"]
    #[inline(always)]
    pub fn is_synch(&self) -> bool {
        **self == FILTSEL_A::SYNCH
    }
    #[doc = "Checks if the value of the field is `FILTER`"]
    #[inline(always)]
    pub fn is_filter(&self) -> bool {
        **self == FILTSEL_A::FILTER
    }
}
impl core::ops::Deref for FILTSEL_R {
    type Target = crate::FieldReader<u8, FILTSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FILTSEL` writer - Filter Selection"]
pub struct FILTSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> FILTSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FILTSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Filter disabled"]
    #[inline(always)]
    pub fn disable(self) -> &'a mut W {
        self.variant(FILTSEL_A::DISABLE)
    }
    #[doc = "Synchronizer enabled"]
    #[inline(always)]
    pub fn synch(self) -> &'a mut W {
        self.variant(FILTSEL_A::SYNCH)
    }
    #[doc = "Filter enabled"]
    #[inline(always)]
    pub fn filter(self) -> &'a mut W {
        self.variant(FILTSEL_A::FILTER)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `OUTEN` reader - Output Enable"]
pub struct OUTEN_R(crate::FieldReader<bool, bool>);
impl OUTEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        OUTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OUTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OUTEN` writer - Output Enable"]
pub struct OUTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> OUTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Edge Detection Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum EDGEDET_A {
    #[doc = "0: Edge detector is disabled"]
    DIS = 0,
    #[doc = "1: Edge detector is enabled"]
    EN = 1,
}
impl From<EDGEDET_A> for bool {
    #[inline(always)]
    fn from(variant: EDGEDET_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `EDGEDET` reader - Edge Detection Enable"]
pub struct EDGEDET_R(crate::FieldReader<bool, EDGEDET_A>);
impl EDGEDET_R {
    pub(crate) fn new(bits: bool) -> Self {
        EDGEDET_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> EDGEDET_A {
        match self.bits {
            false => EDGEDET_A::DIS,
            true => EDGEDET_A::EN,
        }
    }
    #[doc = "Checks if the value of the field is `DIS`"]
    #[inline(always)]
    pub fn is_dis(&self) -> bool {
        **self == EDGEDET_A::DIS
    }
    #[doc = "Checks if the value of the field is `EN`"]
    #[inline(always)]
    pub fn is_en(&self) -> bool {
        **self == EDGEDET_A::EN
    }
}
impl core::ops::Deref for EDGEDET_R {
    type Target = crate::FieldReader<bool, EDGEDET_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EDGEDET` writer - Edge Detection Enable"]
pub struct EDGEDET_W<'a> {
    w: &'a mut W,
}
impl<'a> EDGEDET_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EDGEDET_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Edge detector is disabled"]
    #[inline(always)]
    pub fn dis(self) -> &'a mut W {
        self.variant(EDGEDET_A::DIS)
    }
    #[doc = "Edge detector is enabled"]
    #[inline(always)]
    pub fn en(self) -> &'a mut W {
        self.variant(EDGEDET_A::EN)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - LUT Enable"]
    #[inline(always)]
    pub fn enable(&self) -> ENABLE_R {
        ENABLE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:3 - Clock Source Selection"]
    #[inline(always)]
    pub fn clksrc(&self) -> CLKSRC_R {
        CLKSRC_R::new(((self.bits >> 1) & 0x07) as u8)
    }
    #[doc = "Bits 4:5 - Filter Selection"]
    #[inline(always)]
    pub fn filtsel(&self) -> FILTSEL_R {
        FILTSEL_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Output Enable"]
    #[inline(always)]
    pub fn outen(&self) -> OUTEN_R {
        OUTEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Edge Detection Enable"]
    #[inline(always)]
    pub fn edgedet(&self) -> EDGEDET_R {
        EDGEDET_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - LUT Enable"]
    #[inline(always)]
    pub fn enable(&mut self) -> ENABLE_W {
        ENABLE_W { w: self }
    }
    #[doc = "Bits 1:3 - Clock Source Selection"]
    #[inline(always)]
    pub fn clksrc(&mut self) -> CLKSRC_W {
        CLKSRC_W { w: self }
    }
    #[doc = "Bits 4:5 - Filter Selection"]
    #[inline(always)]
    pub fn filtsel(&mut self) -> FILTSEL_W {
        FILTSEL_W { w: self }
    }
    #[doc = "Bit 6 - Output Enable"]
    #[inline(always)]
    pub fn outen(&mut self) -> OUTEN_W {
        OUTEN_W { w: self }
    }
    #[doc = "Bit 7 - Edge Detection Enable"]
    #[inline(always)]
    pub fn edgedet(&mut self) -> EDGEDET_W {
        EDGEDET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LUT Control 3 A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lut3ctrla](index.html) module"]
pub struct LUT3CTRLA_SPEC;
impl crate::RegisterSpec for LUT3CTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [lut3ctrla::R](R) reader structure"]
impl crate::Readable for LUT3CTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lut3ctrla::W](W) writer structure"]
impl crate::Writable for LUT3CTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LUT3CTRLA to value 0"]
impl crate::Resettable for LUT3CTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
