#[doc = "Register `DACREF` reader"]
pub struct R(crate::R<DACREF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DACREF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DACREF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DACREF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DACREF` writer"]
pub struct W(crate::W<DACREF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DACREF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DACREF_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DACREF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DATA` reader - DAC voltage reference"]
pub struct DATA_R(crate::FieldReader<u8, u8>);
impl DATA_R {
    pub(crate) fn new(bits: u8) -> Self {
        DATA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DATA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DATA` writer - DAC voltage reference"]
pub struct DATA_W<'a> {
    w: &'a mut W,
}
impl<'a> DATA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - DAC voltage reference"]
    #[inline(always)]
    pub fn data(&self) -> DATA_R {
        DATA_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - DAC voltage reference"]
    #[inline(always)]
    pub fn data(&mut self) -> DATA_W {
        DATA_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Referance scale control\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dacref](index.html) module"]
pub struct DACREF_SPEC;
impl crate::RegisterSpec for DACREF_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [dacref::R](R) reader structure"]
impl crate::Readable for DACREF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dacref::W](W) writer structure"]
impl crate::Writable for DACREF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DACREF to value 0"]
impl crate::Resettable for DACREF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
