#[doc = "Register `USBSTA` reader"]
pub struct R(crate::R<USBSTA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<USBSTA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<USBSTA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<USBSTA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `USBSTA` writer"]
pub struct W(crate::W<USBSTA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<USBSTA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<USBSTA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<USBSTA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `VBUS` reader - No Description."]
pub struct VBUS_R(crate::FieldReader<bool, bool>);
impl VBUS_R {
    pub(crate) fn new(bits: bool) -> Self {
        VBUS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VBUS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VBUS` writer - No Description."]
pub struct VBUS_W<'a> {
    w: &'a mut W,
}
impl<'a> VBUS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `SPEED` reader - No Description."]
pub struct SPEED_R(crate::FieldReader<bool, bool>);
impl SPEED_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPEED_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPEED_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPEED` writer - No Description."]
pub struct SPEED_W<'a> {
    w: &'a mut W,
}
impl<'a> SPEED_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn vbus(&self) -> VBUS_R {
        VBUS_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 3 - No Description."]
    #[inline(always)]
    pub fn speed(&self) -> SPEED_R {
        SPEED_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn vbus(&mut self) -> VBUS_W {
        VBUS_W { w: self }
    }
    #[doc = "Bit 3 - No Description."]
    #[inline(always)]
    pub fn speed(&mut self) -> SPEED_W {
        SPEED_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [usbsta](index.html) module"]
pub struct USBSTA_SPEC;
impl crate::RegisterSpec for USBSTA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [usbsta::R](R) reader structure"]
impl crate::Readable for USBSTA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [usbsta::W](W) writer structure"]
impl crate::Writable for USBSTA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets USBSTA to value 0"]
impl crate::Resettable for USBSTA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
