#[doc = "Register `TCCR4E` reader"]
pub struct R(crate::R<TCCR4E_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR4E_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR4E_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR4E_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR4E` writer"]
pub struct W(crate::W<TCCR4E_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR4E_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR4E_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR4E_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `OC4OE` reader - Output Compare Override Enable bit"]
pub struct OC4OE_R(crate::FieldReader<u8, u8>);
impl OC4OE_R {
    pub(crate) fn new(bits: u8) -> Self {
        OC4OE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OC4OE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OC4OE` writer - Output Compare Override Enable bit"]
pub struct OC4OE_W<'a> {
    w: &'a mut W,
}
impl<'a> OC4OE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u8 & 0x3f);
        self.w
    }
}
#[doc = "Field `ENHC4` reader - Enhanced Compare/PWM Mode"]
pub struct ENHC4_R(crate::FieldReader<bool, bool>);
impl ENHC4_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENHC4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENHC4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENHC4` writer - Enhanced Compare/PWM Mode"]
pub struct ENHC4_W<'a> {
    w: &'a mut W,
}
impl<'a> ENHC4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TLOCK4` reader - Register Update Lock"]
pub struct TLOCK4_R(crate::FieldReader<bool, bool>);
impl TLOCK4_R {
    pub(crate) fn new(bits: bool) -> Self {
        TLOCK4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TLOCK4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TLOCK4` writer - Register Update Lock"]
pub struct TLOCK4_W<'a> {
    w: &'a mut W,
}
impl<'a> TLOCK4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:5 - Output Compare Override Enable bit"]
    #[inline(always)]
    pub fn oc4oe(&self) -> OC4OE_R {
        OC4OE_R::new((self.bits & 0x3f) as u8)
    }
    #[doc = "Bit 6 - Enhanced Compare/PWM Mode"]
    #[inline(always)]
    pub fn enhc4(&self) -> ENHC4_R {
        ENHC4_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Register Update Lock"]
    #[inline(always)]
    pub fn tlock4(&self) -> TLOCK4_R {
        TLOCK4_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:5 - Output Compare Override Enable bit"]
    #[inline(always)]
    pub fn oc4oe(&mut self) -> OC4OE_W {
        OC4OE_W { w: self }
    }
    #[doc = "Bit 6 - Enhanced Compare/PWM Mode"]
    #[inline(always)]
    pub fn enhc4(&mut self) -> ENHC4_W {
        ENHC4_W { w: self }
    }
    #[doc = "Bit 7 - Register Update Lock"]
    #[inline(always)]
    pub fn tlock4(&mut self) -> TLOCK4_W {
        TLOCK4_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter 4 Control Register E\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr4e](index.html) module"]
pub struct TCCR4E_SPEC;
impl crate::RegisterSpec for TCCR4E_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr4e::R](R) reader structure"]
impl crate::Readable for TCCR4E_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr4e::W](W) writer structure"]
impl crate::Writable for TCCR4E_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR4E to value 0"]
impl crate::Resettable for TCCR4E_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
