#[doc = "Register `TCCR4D` reader"]
pub struct R(crate::R<TCCR4D_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR4D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR4D_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR4D_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR4D` writer"]
pub struct W(crate::W<TCCR4D_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR4D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR4D_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR4D_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Waveform Generation Mode bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WGM4_A {
    #[doc = "0: Fast PWM, Update: *TOP*, Flag: *TOP*"]
    PWM_FAST = 0,
    #[doc = "1: Phase and Frequency Correct PWM, Update: *BOTTOM*, Flag: *BOTTOM*"]
    PWM_CORRECT = 1,
    #[doc = "2: PWM6 / Single-slope, Update: *TOP*, Flag: *TOP*"]
    PWM_SINGLE_SLOPE = 2,
    #[doc = "3: PWM6 / Dual-slope, Update: *BOTTOM*, Flag: *BOTTOM*"]
    PWM_DUAL_SLOPE = 3,
}
impl From<WGM4_A> for u8 {
    #[inline(always)]
    fn from(variant: WGM4_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WGM4` reader - Waveform Generation Mode bits"]
pub struct WGM4_R(crate::FieldReader<u8, WGM4_A>);
impl WGM4_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM4_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WGM4_A {
        match self.bits {
            0 => WGM4_A::PWM_FAST,
            1 => WGM4_A::PWM_CORRECT,
            2 => WGM4_A::PWM_SINGLE_SLOPE,
            3 => WGM4_A::PWM_DUAL_SLOPE,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `PWM_FAST`"]
    #[inline(always)]
    pub fn is_pwm_fast(&self) -> bool {
        **self == WGM4_A::PWM_FAST
    }
    #[doc = "Checks if the value of the field is `PWM_CORRECT`"]
    #[inline(always)]
    pub fn is_pwm_correct(&self) -> bool {
        **self == WGM4_A::PWM_CORRECT
    }
    #[doc = "Checks if the value of the field is `PWM_SINGLE_SLOPE`"]
    #[inline(always)]
    pub fn is_pwm_single_slope(&self) -> bool {
        **self == WGM4_A::PWM_SINGLE_SLOPE
    }
    #[doc = "Checks if the value of the field is `PWM_DUAL_SLOPE`"]
    #[inline(always)]
    pub fn is_pwm_dual_slope(&self) -> bool {
        **self == WGM4_A::PWM_DUAL_SLOPE
    }
}
impl core::ops::Deref for WGM4_R {
    type Target = crate::FieldReader<u8, WGM4_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM4` writer - Waveform Generation Mode bits"]
pub struct WGM4_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WGM4_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Fast PWM, Update: *TOP*, Flag: *TOP*"]
    #[inline(always)]
    pub fn pwm_fast(self) -> &'a mut W {
        self.variant(WGM4_A::PWM_FAST)
    }
    #[doc = "Phase and Frequency Correct PWM, Update: *BOTTOM*, Flag: *BOTTOM*"]
    #[inline(always)]
    pub fn pwm_correct(self) -> &'a mut W {
        self.variant(WGM4_A::PWM_CORRECT)
    }
    #[doc = "PWM6 / Single-slope, Update: *TOP*, Flag: *TOP*"]
    #[inline(always)]
    pub fn pwm_single_slope(self) -> &'a mut W {
        self.variant(WGM4_A::PWM_SINGLE_SLOPE)
    }
    #[doc = "PWM6 / Dual-slope, Update: *BOTTOM*, Flag: *BOTTOM*"]
    #[inline(always)]
    pub fn pwm_dual_slope(self) -> &'a mut W {
        self.variant(WGM4_A::PWM_DUAL_SLOPE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `FPF4` reader - Fault Protection Interrupt Flag"]
pub struct FPF4_R(crate::FieldReader<bool, bool>);
impl FPF4_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPF4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPF4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPF4` writer - Fault Protection Interrupt Flag"]
pub struct FPF4_W<'a> {
    w: &'a mut W,
}
impl<'a> FPF4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FPAC4` reader - Fault Protection Analog Comparator Enable"]
pub struct FPAC4_R(crate::FieldReader<bool, bool>);
impl FPAC4_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPAC4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPAC4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPAC4` writer - Fault Protection Analog Comparator Enable"]
pub struct FPAC4_W<'a> {
    w: &'a mut W,
}
impl<'a> FPAC4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `FPES4` reader - Fault Protection Edge Select"]
pub struct FPES4_R(crate::FieldReader<bool, bool>);
impl FPES4_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPES4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPES4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPES4` writer - Fault Protection Edge Select"]
pub struct FPES4_W<'a> {
    w: &'a mut W,
}
impl<'a> FPES4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `FPNC4` reader - Fault Protection Noise Canceler"]
pub struct FPNC4_R(crate::FieldReader<bool, bool>);
impl FPNC4_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPNC4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPNC4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPNC4` writer - Fault Protection Noise Canceler"]
pub struct FPNC4_W<'a> {
    w: &'a mut W,
}
impl<'a> FPNC4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `FPEN4` reader - Fault Protection Mode Enable"]
pub struct FPEN4_R(crate::FieldReader<bool, bool>);
impl FPEN4_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPEN4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPEN4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPEN4` writer - Fault Protection Mode Enable"]
pub struct FPEN4_W<'a> {
    w: &'a mut W,
}
impl<'a> FPEN4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FPIE4` reader - Fault Protection Interrupt Enable"]
pub struct FPIE4_R(crate::FieldReader<bool, bool>);
impl FPIE4_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPIE4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPIE4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPIE4` writer - Fault Protection Interrupt Enable"]
pub struct FPIE4_W<'a> {
    w: &'a mut W,
}
impl<'a> FPIE4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform Generation Mode bits"]
    #[inline(always)]
    pub fn wgm4(&self) -> WGM4_R {
        WGM4_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Fault Protection Interrupt Flag"]
    #[inline(always)]
    pub fn fpf4(&self) -> FPF4_R {
        FPF4_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Fault Protection Analog Comparator Enable"]
    #[inline(always)]
    pub fn fpac4(&self) -> FPAC4_R {
        FPAC4_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Fault Protection Edge Select"]
    #[inline(always)]
    pub fn fpes4(&self) -> FPES4_R {
        FPES4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Fault Protection Noise Canceler"]
    #[inline(always)]
    pub fn fpnc4(&self) -> FPNC4_R {
        FPNC4_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Fault Protection Mode Enable"]
    #[inline(always)]
    pub fn fpen4(&self) -> FPEN4_R {
        FPEN4_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Fault Protection Interrupt Enable"]
    #[inline(always)]
    pub fn fpie4(&self) -> FPIE4_R {
        FPIE4_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform Generation Mode bits"]
    #[inline(always)]
    pub fn wgm4(&mut self) -> WGM4_W {
        WGM4_W { w: self }
    }
    #[doc = "Bit 2 - Fault Protection Interrupt Flag"]
    #[inline(always)]
    pub fn fpf4(&mut self) -> FPF4_W {
        FPF4_W { w: self }
    }
    #[doc = "Bit 3 - Fault Protection Analog Comparator Enable"]
    #[inline(always)]
    pub fn fpac4(&mut self) -> FPAC4_W {
        FPAC4_W { w: self }
    }
    #[doc = "Bit 4 - Fault Protection Edge Select"]
    #[inline(always)]
    pub fn fpes4(&mut self) -> FPES4_W {
        FPES4_W { w: self }
    }
    #[doc = "Bit 5 - Fault Protection Noise Canceler"]
    #[inline(always)]
    pub fn fpnc4(&mut self) -> FPNC4_W {
        FPNC4_W { w: self }
    }
    #[doc = "Bit 6 - Fault Protection Mode Enable"]
    #[inline(always)]
    pub fn fpen4(&mut self) -> FPEN4_W {
        FPEN4_W { w: self }
    }
    #[doc = "Bit 7 - Fault Protection Interrupt Enable"]
    #[inline(always)]
    pub fn fpie4(&mut self) -> FPIE4_W {
        FPIE4_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter 4 Control Register D\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr4d](index.html) module"]
pub struct TCCR4D_SPEC;
impl crate::RegisterSpec for TCCR4D_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr4d::R](R) reader structure"]
impl crate::Readable for TCCR4D_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr4d::W](W) writer structure"]
impl crate::Writable for TCCR4D_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR4D to value 0"]
impl crate::Resettable for TCCR4D_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
