#[doc = "Register `PORTE` reader"]
pub struct R(crate::R<PORTE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PORTE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PORTE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PORTE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PORTE` writer"]
pub struct W(crate::W<PORTE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PORTE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PORTE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PORTE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PE2` reader - Pin E2"]
pub struct PE2_R(crate::FieldReader<bool, bool>);
impl PE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PE2` writer - Pin E2"]
pub struct PE2_W<'a> {
    w: &'a mut W,
}
impl<'a> PE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PE6` reader - Pin E6"]
pub struct PE6_R(crate::FieldReader<bool, bool>);
impl PE6_R {
    pub(crate) fn new(bits: bool) -> Self {
        PE6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PE6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PE6` writer - Pin E6"]
pub struct PE6_W<'a> {
    w: &'a mut W,
}
impl<'a> PE6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - Pin E2"]
    #[inline(always)]
    pub fn pe2(&self) -> PE2_R {
        PE2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Pin E6"]
    #[inline(always)]
    pub fn pe6(&self) -> PE6_R {
        PE6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Pin E2"]
    #[inline(always)]
    pub fn pe2(&mut self) -> PE2_W {
        PE2_W { w: self }
    }
    #[doc = "Bit 6 - Pin E6"]
    #[inline(always)]
    pub fn pe6(&mut self) -> PE6_W {
        PE6_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Data Register, Port E\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [porte](index.html) module"]
pub struct PORTE_SPEC;
impl crate::RegisterSpec for PORTE_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [porte::R](R) reader structure"]
impl crate::Readable for PORTE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [porte::W](W) writer structure"]
impl crate::Writable for PORTE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PORTE to value 0"]
impl crate::Resettable for PORTE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
