#[doc = "Register `RCCTRL` reader"]
pub struct R(crate::R<RCCTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RCCTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RCCTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RCCTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RCCTRL` writer"]
pub struct W(crate::W<RCCTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RCCTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RCCTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RCCTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RCFREQ` reader - No Description."]
pub struct RCFREQ_R(crate::FieldReader<bool, bool>);
impl RCFREQ_R {
    pub(crate) fn new(bits: bool) -> Self {
        RCFREQ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RCFREQ_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RCFREQ` writer - No Description."]
pub struct RCFREQ_W<'a> {
    w: &'a mut W,
}
impl<'a> RCFREQ_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn rcfreq(&self) -> RCFREQ_R {
        RCFREQ_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn rcfreq(&mut self) -> RCFREQ_W {
        RCFREQ_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Oscillator Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rcctrl](index.html) module"]
pub struct RCCTRL_SPEC;
impl crate::RegisterSpec for RCCTRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [rcctrl::R](R) reader structure"]
impl crate::Readable for RCCTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rcctrl::W](W) writer structure"]
impl crate::Writable for RCCTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RCCTRL to value 0"]
impl crate::Resettable for RCCTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
