#[doc = "Register `SPCR` reader"]
pub struct R(crate::R<SPCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPCR` writer"]
pub struct W(crate::W<SPCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "SPI Clock Rate Selects\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SPR_A {
    #[doc = "0: Fosc/4 if SPI2X == 0 else Fosc/2"]
    FOSC_4_2 = 0,
    #[doc = "1: Fosc/16 if SPI2X == 0 else Fosc/8"]
    FOSC_16_8 = 1,
    #[doc = "2: Fosc/64 if SPI2X == 0 else Fosc/32"]
    FOSC_64_32 = 2,
    #[doc = "3: Fosc/128 if SPI2X == 0 else Fosc/64"]
    FOSC_128_64 = 3,
}
impl From<SPR_A> for u8 {
    #[inline(always)]
    fn from(variant: SPR_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SPR` reader - SPI Clock Rate Selects"]
pub struct SPR_R(crate::FieldReader<u8, SPR_A>);
impl SPR_R {
    pub(crate) fn new(bits: u8) -> Self {
        SPR_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SPR_A {
        match self.bits {
            0 => SPR_A::FOSC_4_2,
            1 => SPR_A::FOSC_16_8,
            2 => SPR_A::FOSC_64_32,
            3 => SPR_A::FOSC_128_64,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `FOSC_4_2`"]
    #[inline(always)]
    pub fn is_fosc_4_2(&self) -> bool {
        **self == SPR_A::FOSC_4_2
    }
    #[doc = "Checks if the value of the field is `FOSC_16_8`"]
    #[inline(always)]
    pub fn is_fosc_16_8(&self) -> bool {
        **self == SPR_A::FOSC_16_8
    }
    #[doc = "Checks if the value of the field is `FOSC_64_32`"]
    #[inline(always)]
    pub fn is_fosc_64_32(&self) -> bool {
        **self == SPR_A::FOSC_64_32
    }
    #[doc = "Checks if the value of the field is `FOSC_128_64`"]
    #[inline(always)]
    pub fn is_fosc_128_64(&self) -> bool {
        **self == SPR_A::FOSC_128_64
    }
}
impl core::ops::Deref for SPR_R {
    type Target = crate::FieldReader<u8, SPR_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPR` writer - SPI Clock Rate Selects"]
pub struct SPR_W<'a> {
    w: &'a mut W,
}
impl<'a> SPR_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SPR_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Fosc/4 if SPI2X == 0 else Fosc/2"]
    #[inline(always)]
    pub fn fosc_4_2(self) -> &'a mut W {
        self.variant(SPR_A::FOSC_4_2)
    }
    #[doc = "Fosc/16 if SPI2X == 0 else Fosc/8"]
    #[inline(always)]
    pub fn fosc_16_8(self) -> &'a mut W {
        self.variant(SPR_A::FOSC_16_8)
    }
    #[doc = "Fosc/64 if SPI2X == 0 else Fosc/32"]
    #[inline(always)]
    pub fn fosc_64_32(self) -> &'a mut W {
        self.variant(SPR_A::FOSC_64_32)
    }
    #[doc = "Fosc/128 if SPI2X == 0 else Fosc/64"]
    #[inline(always)]
    pub fn fosc_128_64(self) -> &'a mut W {
        self.variant(SPR_A::FOSC_128_64)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `CPHA` reader - Clock Phase"]
pub struct CPHA_R(crate::FieldReader<bool, bool>);
impl CPHA_R {
    pub(crate) fn new(bits: bool) -> Self {
        CPHA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CPHA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CPHA` writer - Clock Phase"]
pub struct CPHA_W<'a> {
    w: &'a mut W,
}
impl<'a> CPHA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `CPOL` reader - Clock polarity"]
pub struct CPOL_R(crate::FieldReader<bool, bool>);
impl CPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        CPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CPOL` writer - Clock polarity"]
pub struct CPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> CPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `MSTR` reader - Master/Slave Select"]
pub struct MSTR_R(crate::FieldReader<bool, bool>);
impl MSTR_R {
    pub(crate) fn new(bits: bool) -> Self {
        MSTR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MSTR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MSTR` writer - Master/Slave Select"]
pub struct MSTR_W<'a> {
    w: &'a mut W,
}
impl<'a> MSTR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `DORD` reader - Data Order"]
pub struct DORD_R(crate::FieldReader<bool, bool>);
impl DORD_R {
    pub(crate) fn new(bits: bool) -> Self {
        DORD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DORD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DORD` writer - Data Order"]
pub struct DORD_W<'a> {
    w: &'a mut W,
}
impl<'a> DORD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `SPE` reader - SPI Enable"]
pub struct SPE_R(crate::FieldReader<bool, bool>);
impl SPE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPE` writer - SPI Enable"]
pub struct SPE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `SPIE` reader - SPI Interrupt Enable"]
pub struct SPIE_R(crate::FieldReader<bool, bool>);
impl SPIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPIE` writer - SPI Interrupt Enable"]
pub struct SPIE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - SPI Clock Rate Selects"]
    #[inline(always)]
    pub fn spr(&self) -> SPR_R {
        SPR_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Clock Phase"]
    #[inline(always)]
    pub fn cpha(&self) -> CPHA_R {
        CPHA_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Clock polarity"]
    #[inline(always)]
    pub fn cpol(&self) -> CPOL_R {
        CPOL_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Master/Slave Select"]
    #[inline(always)]
    pub fn mstr(&self) -> MSTR_R {
        MSTR_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Data Order"]
    #[inline(always)]
    pub fn dord(&self) -> DORD_R {
        DORD_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - SPI Enable"]
    #[inline(always)]
    pub fn spe(&self) -> SPE_R {
        SPE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - SPI Interrupt Enable"]
    #[inline(always)]
    pub fn spie(&self) -> SPIE_R {
        SPIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - SPI Clock Rate Selects"]
    #[inline(always)]
    pub fn spr(&mut self) -> SPR_W {
        SPR_W { w: self }
    }
    #[doc = "Bit 2 - Clock Phase"]
    #[inline(always)]
    pub fn cpha(&mut self) -> CPHA_W {
        CPHA_W { w: self }
    }
    #[doc = "Bit 3 - Clock polarity"]
    #[inline(always)]
    pub fn cpol(&mut self) -> CPOL_W {
        CPOL_W { w: self }
    }
    #[doc = "Bit 4 - Master/Slave Select"]
    #[inline(always)]
    pub fn mstr(&mut self) -> MSTR_W {
        MSTR_W { w: self }
    }
    #[doc = "Bit 5 - Data Order"]
    #[inline(always)]
    pub fn dord(&mut self) -> DORD_W {
        DORD_W { w: self }
    }
    #[doc = "Bit 6 - SPI Enable"]
    #[inline(always)]
    pub fn spe(&mut self) -> SPE_W {
        SPE_W { w: self }
    }
    #[doc = "Bit 7 - SPI Interrupt Enable"]
    #[inline(always)]
    pub fn spie(&mut self) -> SPIE_W {
        SPIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SPI Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spcr](index.html) module"]
pub struct SPCR_SPEC;
impl crate::RegisterSpec for SPCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [spcr::R](R) reader structure"]
impl crate::Readable for SPCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spcr::W](W) writer structure"]
impl crate::Writable for SPCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPCR to value 0"]
impl crate::Resettable for SPCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
