#[doc = "Register `PRR0` reader"]
pub struct R(crate::R<PRR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PRR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PRR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PRR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PRR0` writer"]
pub struct W(crate::W<PRR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PRR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PRR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PRR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PRADC` reader - Power Reduction ADC"]
pub struct PRADC_R(crate::FieldReader<bool, bool>);
impl PRADC_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRADC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRADC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRADC` writer - Power Reduction ADC"]
pub struct PRADC_W<'a> {
    w: &'a mut W,
}
impl<'a> PRADC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PRUSART0` reader - Power Reduction USART0"]
pub struct PRUSART0_R(crate::FieldReader<bool, bool>);
impl PRUSART0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRUSART0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRUSART0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRUSART0` writer - Power Reduction USART0"]
pub struct PRUSART0_W<'a> {
    w: &'a mut W,
}
impl<'a> PRUSART0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PRSPI0` reader - Power Reduction Serial Peripheral Interface 1"]
pub struct PRSPI0_R(crate::FieldReader<bool, bool>);
impl PRSPI0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRSPI0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRSPI0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRSPI0` writer - Power Reduction Serial Peripheral Interface 1"]
pub struct PRSPI0_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSPI0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PRTIM1` reader - Power Reduction Timer/Counter1"]
pub struct PRTIM1_R(crate::FieldReader<bool, bool>);
impl PRTIM1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM1` writer - Power Reduction Timer/Counter1"]
pub struct PRTIM1_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PRUSART1` reader - Power Reduction USART1"]
pub struct PRUSART1_R(crate::FieldReader<bool, bool>);
impl PRUSART1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRUSART1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRUSART1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRUSART1` writer - Power Reduction USART1"]
pub struct PRUSART1_W<'a> {
    w: &'a mut W,
}
impl<'a> PRUSART1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `PRTIM0` reader - Power Reduction Timer/Counter0"]
pub struct PRTIM0_R(crate::FieldReader<bool, bool>);
impl PRTIM0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM0` writer - Power Reduction Timer/Counter0"]
pub struct PRTIM0_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `PRTIM2` reader - Power Reduction Timer/Counter2"]
pub struct PRTIM2_R(crate::FieldReader<bool, bool>);
impl PRTIM2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM2` writer - Power Reduction Timer/Counter2"]
pub struct PRTIM2_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PRTWI0` reader - Power Reduction TWI0"]
pub struct PRTWI0_R(crate::FieldReader<bool, bool>);
impl PRTWI0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTWI0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTWI0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTWI0` writer - Power Reduction TWI0"]
pub struct PRTWI0_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTWI0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Power Reduction ADC"]
    #[inline(always)]
    pub fn pradc(&self) -> PRADC_R {
        PRADC_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Power Reduction USART0"]
    #[inline(always)]
    pub fn prusart0(&self) -> PRUSART0_R {
        PRUSART0_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Power Reduction Serial Peripheral Interface 1"]
    #[inline(always)]
    pub fn prspi0(&self) -> PRSPI0_R {
        PRSPI0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Power Reduction Timer/Counter1"]
    #[inline(always)]
    pub fn prtim1(&self) -> PRTIM1_R {
        PRTIM1_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Power Reduction USART1"]
    #[inline(always)]
    pub fn prusart1(&self) -> PRUSART1_R {
        PRUSART1_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Power Reduction Timer/Counter0"]
    #[inline(always)]
    pub fn prtim0(&self) -> PRTIM0_R {
        PRTIM0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Power Reduction Timer/Counter2"]
    #[inline(always)]
    pub fn prtim2(&self) -> PRTIM2_R {
        PRTIM2_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Power Reduction TWI0"]
    #[inline(always)]
    pub fn prtwi0(&self) -> PRTWI0_R {
        PRTWI0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Power Reduction ADC"]
    #[inline(always)]
    pub fn pradc(&mut self) -> PRADC_W {
        PRADC_W { w: self }
    }
    #[doc = "Bit 1 - Power Reduction USART0"]
    #[inline(always)]
    pub fn prusart0(&mut self) -> PRUSART0_W {
        PRUSART0_W { w: self }
    }
    #[doc = "Bit 2 - Power Reduction Serial Peripheral Interface 1"]
    #[inline(always)]
    pub fn prspi0(&mut self) -> PRSPI0_W {
        PRSPI0_W { w: self }
    }
    #[doc = "Bit 3 - Power Reduction Timer/Counter1"]
    #[inline(always)]
    pub fn prtim1(&mut self) -> PRTIM1_W {
        PRTIM1_W { w: self }
    }
    #[doc = "Bit 4 - Power Reduction USART1"]
    #[inline(always)]
    pub fn prusart1(&mut self) -> PRUSART1_W {
        PRUSART1_W { w: self }
    }
    #[doc = "Bit 5 - Power Reduction Timer/Counter0"]
    #[inline(always)]
    pub fn prtim0(&mut self) -> PRTIM0_W {
        PRTIM0_W { w: self }
    }
    #[doc = "Bit 6 - Power Reduction Timer/Counter2"]
    #[inline(always)]
    pub fn prtim2(&mut self) -> PRTIM2_W {
        PRTIM2_W { w: self }
    }
    #[doc = "Bit 7 - Power Reduction TWI0"]
    #[inline(always)]
    pub fn prtwi0(&mut self) -> PRTWI0_W {
        PRTWI0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Power Reduction Register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [prr0](index.html) module"]
pub struct PRR0_SPEC;
impl crate::RegisterSpec for PRR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [prr0::R](R) reader structure"]
impl crate::Readable for PRR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [prr0::W](W) writer structure"]
impl crate::Writable for PRR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PRR0 to value 0"]
impl crate::Resettable for PRR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
