#[doc = "Register `MCUSR` reader"]
pub struct R(crate::R<MCUSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCUSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCUSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCUSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MCUSR` writer"]
pub struct W(crate::W<MCUSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MCUSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MCUSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MCUSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PORF` reader - Power-on reset flag"]
pub struct PORF_R(crate::FieldReader<bool, bool>);
impl PORF_R {
    pub(crate) fn new(bits: bool) -> Self {
        PORF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PORF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PORF` writer - Power-on reset flag"]
pub struct PORF_W<'a> {
    w: &'a mut W,
}
impl<'a> PORF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `EXTRF` reader - External Reset Flag"]
pub struct EXTRF_R(crate::FieldReader<bool, bool>);
impl EXTRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        EXTRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXTRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXTRF` writer - External Reset Flag"]
pub struct EXTRF_W<'a> {
    w: &'a mut W,
}
impl<'a> EXTRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `BORF` reader - Brown-out Reset Flag"]
pub struct BORF_R(crate::FieldReader<bool, bool>);
impl BORF_R {
    pub(crate) fn new(bits: bool) -> Self {
        BORF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BORF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BORF` writer - Brown-out Reset Flag"]
pub struct BORF_W<'a> {
    w: &'a mut W,
}
impl<'a> BORF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `WDRF` reader - Watchdog Reset Flag"]
pub struct WDRF_R(crate::FieldReader<bool, bool>);
impl WDRF_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDRF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDRF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDRF` writer - Watchdog Reset Flag"]
pub struct WDRF_W<'a> {
    w: &'a mut W,
}
impl<'a> WDRF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Power-on reset flag"]
    #[inline(always)]
    pub fn porf(&self) -> PORF_R {
        PORF_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - External Reset Flag"]
    #[inline(always)]
    pub fn extrf(&self) -> EXTRF_R {
        EXTRF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Brown-out Reset Flag"]
    #[inline(always)]
    pub fn borf(&self) -> BORF_R {
        BORF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Watchdog Reset Flag"]
    #[inline(always)]
    pub fn wdrf(&self) -> WDRF_R {
        WDRF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Power-on reset flag"]
    #[inline(always)]
    pub fn porf(&mut self) -> PORF_W {
        PORF_W { w: self }
    }
    #[doc = "Bit 1 - External Reset Flag"]
    #[inline(always)]
    pub fn extrf(&mut self) -> EXTRF_W {
        EXTRF_W { w: self }
    }
    #[doc = "Bit 2 - Brown-out Reset Flag"]
    #[inline(always)]
    pub fn borf(&mut self) -> BORF_W {
        BORF_W { w: self }
    }
    #[doc = "Bit 3 - Watchdog Reset Flag"]
    #[inline(always)]
    pub fn wdrf(&mut self) -> WDRF_W {
        WDRF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "MCU Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mcusr](index.html) module"]
pub struct MCUSR_SPEC;
impl crate::RegisterSpec for MCUSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mcusr::R](R) reader structure"]
impl crate::Readable for MCUSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mcusr::W](W) writer structure"]
impl crate::Writable for MCUSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MCUSR to value 0"]
impl crate::Resettable for MCUSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
