#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Analog Comparator Control And Status Register-B"]
    pub acsrb: crate::Reg<acsrb::ACSRB_SPEC>,
    _reserved_1_acsr: [u8; 0x01],
    _reserved2: [u8; 0x2e],
    #[doc = "0x30 - Digital Input Disable Register 1"]
    pub didr1: crate::Reg<didr1::DIDR1_SPEC>,
}
impl RegisterBlock {
    #[doc = "0x01 - Analog Comparator Control And Status Register-A"]
    #[inline(always)]
    pub fn acsra(&self) -> &crate::Reg<acsra::ACSRA_SPEC> {
        unsafe {
            &*(((self as *const Self) as *const u8).add(1usize)
                as *const crate::Reg<acsra::ACSRA_SPEC>)
        }
    }
    #[doc = "0x01 - Analog Comparator Control And Status Register"]
    #[inline(always)]
    pub fn acsr(&self) -> &crate::Reg<acsr::ACSR_SPEC> {
        unsafe {
            &*(((self as *const Self) as *const u8).add(1usize)
                as *const crate::Reg<acsr::ACSR_SPEC>)
        }
    }
}
#[doc = "ACSR register accessor: an alias for `Reg<ACSR_SPEC>`"]
pub type ACSR = crate::Reg<acsr::ACSR_SPEC>;
#[doc = "Analog Comparator Control And Status Register"]
pub mod acsr;
#[doc = "ACSRA register accessor: an alias for `Reg<ACSRA_SPEC>`"]
pub type ACSRA = crate::Reg<acsra::ACSRA_SPEC>;
#[doc = "Analog Comparator Control And Status Register-A"]
pub mod acsra;
#[doc = "ACSRB register accessor: an alias for `Reg<ACSRB_SPEC>`"]
pub type ACSRB = crate::Reg<acsrb::ACSRB_SPEC>;
#[doc = "Analog Comparator Control And Status Register-B"]
pub mod acsrb;
#[doc = "DIDR1 register accessor: an alias for `Reg<DIDR1_SPEC>`"]
pub type DIDR1 = crate::Reg<didr1::DIDR1_SPEC>;
#[doc = "Digital Input Disable Register 1"]
pub mod didr1;
