#[doc = "Register `TIFR1` reader"]
pub struct R(crate::R<TIFR1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIFR1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIFR1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIFR1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIFR1` writer"]
pub struct W(crate::W<TIFR1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIFR1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIFR1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIFR1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOV1` reader - Timer/Counter1 Overflow Flag"]
pub struct TOV1_R(crate::FieldReader<bool, bool>);
impl TOV1_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOV1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOV1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOV1` writer - Timer/Counter1 Overflow Flag"]
pub struct TOV1_W<'a> {
    w: &'a mut W,
}
impl<'a> TOV1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCF1A` reader - Output Compare Flag 1A"]
pub struct OCF1A_R(crate::FieldReader<bool, bool>);
impl OCF1A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF1A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF1A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF1A` writer - Output Compare Flag 1A"]
pub struct OCF1A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF1A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCF1B` reader - Output Compare Flag 1B"]
pub struct OCF1B_R(crate::FieldReader<bool, bool>);
impl OCF1B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF1B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF1B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF1B` writer - Output Compare Flag 1B"]
pub struct OCF1B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF1B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ICF1` reader - Input Capture Flag 1"]
pub struct ICF1_R(crate::FieldReader<bool, bool>);
impl ICF1_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICF1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICF1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICF1` writer - Input Capture Flag 1"]
pub struct ICF1_W<'a> {
    w: &'a mut W,
}
impl<'a> ICF1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter1 Overflow Flag"]
    #[inline(always)]
    pub fn tov1(&self) -> TOV1_R {
        TOV1_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Output Compare Flag 1A"]
    #[inline(always)]
    pub fn ocf1a(&self) -> OCF1A_R {
        OCF1A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Output Compare Flag 1B"]
    #[inline(always)]
    pub fn ocf1b(&self) -> OCF1B_R {
        OCF1B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Input Capture Flag 1"]
    #[inline(always)]
    pub fn icf1(&self) -> ICF1_R {
        ICF1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter1 Overflow Flag"]
    #[inline(always)]
    pub fn tov1(&mut self) -> TOV1_W {
        TOV1_W { w: self }
    }
    #[doc = "Bit 1 - Output Compare Flag 1A"]
    #[inline(always)]
    pub fn ocf1a(&mut self) -> OCF1A_W {
        OCF1A_W { w: self }
    }
    #[doc = "Bit 2 - Output Compare Flag 1B"]
    #[inline(always)]
    pub fn ocf1b(&mut self) -> OCF1B_W {
        OCF1B_W { w: self }
    }
    #[doc = "Bit 5 - Input Capture Flag 1"]
    #[inline(always)]
    pub fn icf1(&mut self) -> ICF1_W {
        ICF1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Interrupt Flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tifr1](index.html) module"]
pub struct TIFR1_SPEC;
impl crate::RegisterSpec for TIFR1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tifr1::R](R) reader structure"]
impl crate::Readable for TIFR1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tifr1::W](W) writer structure"]
impl crate::Writable for TIFR1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIFR1 to value 0"]
impl crate::Resettable for TIFR1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
