#[doc = "Register `TCCR5A` reader"]
pub struct R(crate::R<TCCR5A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR5A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR5A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR5A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR5A` writer"]
pub struct W(crate::W<TCCR5A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR5A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR5A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR5A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WGM5` reader - Waveform Generation Mode"]
pub struct WGM5_R(crate::FieldReader<u8, u8>);
impl WGM5_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM5_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM5` writer - Waveform Generation Mode"]
pub struct WGM5_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM5_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Compare Output Mode 5C, bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM5C_A {
    #[doc = "0: Normal port operation, OCix disconnected"]
    DISCONNECTED = 0,
    #[doc = "1: Toggle OCix on Compare Match (Might depend on WGM)"]
    MATCH_TOGGLE = 1,
    #[doc = "2: Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    MATCH_CLEAR = 2,
    #[doc = "3: Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    MATCH_SET = 3,
}
impl From<COM5C_A> for u8 {
    #[inline(always)]
    fn from(variant: COM5C_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM5C` reader - Compare Output Mode 5C, bits"]
pub struct COM5C_R(crate::FieldReader<u8, COM5C_A>);
impl COM5C_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM5C_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM5C_A {
        match self.bits {
            0 => COM5C_A::DISCONNECTED,
            1 => COM5C_A::MATCH_TOGGLE,
            2 => COM5C_A::MATCH_CLEAR,
            3 => COM5C_A::MATCH_SET,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DISCONNECTED`"]
    #[inline(always)]
    pub fn is_disconnected(&self) -> bool {
        **self == COM5C_A::DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `MATCH_TOGGLE`"]
    #[inline(always)]
    pub fn is_match_toggle(&self) -> bool {
        **self == COM5C_A::MATCH_TOGGLE
    }
    #[doc = "Checks if the value of the field is `MATCH_CLEAR`"]
    #[inline(always)]
    pub fn is_match_clear(&self) -> bool {
        **self == COM5C_A::MATCH_CLEAR
    }
    #[doc = "Checks if the value of the field is `MATCH_SET`"]
    #[inline(always)]
    pub fn is_match_set(&self) -> bool {
        **self == COM5C_A::MATCH_SET
    }
}
impl core::ops::Deref for COM5C_R {
    type Target = crate::FieldReader<u8, COM5C_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM5C` writer - Compare Output Mode 5C, bits"]
pub struct COM5C_W<'a> {
    w: &'a mut W,
}
impl<'a> COM5C_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM5C_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM5C_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM5C_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM5C_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM5C_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Compare Output Mode 5B, bits"]
pub type COM5B_A = COM5C_A;
#[doc = "Field `COM5B` reader - Compare Output Mode 5B, bits"]
pub type COM5B_R = COM5C_R;
#[doc = "Field `COM5B` writer - Compare Output Mode 5B, bits"]
pub struct COM5B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM5B_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM5B_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM5B_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM5B_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM5B_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM5B_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Compare Output Mode 1A, bits"]
pub type COM5A_A = COM5C_A;
#[doc = "Field `COM5A` reader - Compare Output Mode 1A, bits"]
pub type COM5A_R = COM5C_R;
#[doc = "Field `COM5A` writer - Compare Output Mode 1A, bits"]
pub struct COM5A_W<'a> {
    w: &'a mut W,
}
impl<'a> COM5A_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM5A_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM5A_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM5A_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at BOTTOM)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM5A_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at BOTTOM)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM5A_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm5(&self) -> WGM5_R {
        WGM5_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Compare Output Mode 5C, bits"]
    #[inline(always)]
    pub fn com5c(&self) -> COM5C_R {
        COM5C_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Compare Output Mode 5B, bits"]
    #[inline(always)]
    pub fn com5b(&self) -> COM5B_R {
        COM5B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Compare Output Mode 1A, bits"]
    #[inline(always)]
    pub fn com5a(&self) -> COM5A_R {
        COM5A_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm5(&mut self) -> WGM5_W {
        WGM5_W { w: self }
    }
    #[doc = "Bits 2:3 - Compare Output Mode 5C, bits"]
    #[inline(always)]
    pub fn com5c(&mut self) -> COM5C_W {
        COM5C_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Output Mode 5B, bits"]
    #[inline(always)]
    pub fn com5b(&mut self) -> COM5B_W {
        COM5B_W { w: self }
    }
    #[doc = "Bits 6:7 - Compare Output Mode 1A, bits"]
    #[inline(always)]
    pub fn com5a(&mut self) -> COM5A_W {
        COM5A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter5 Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr5a](index.html) module"]
pub struct TCCR5A_SPEC;
impl crate::RegisterSpec for TCCR5A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr5a::R](R) reader structure"]
impl crate::Readable for TCCR5A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr5a::W](W) writer structure"]
impl crate::Writable for TCCR5A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR5A to value 0"]
impl crate::Resettable for TCCR5A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
