#[doc = "Register `TIFR3` reader"]
pub struct R(crate::R<TIFR3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIFR3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIFR3_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIFR3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIFR3` writer"]
pub struct W(crate::W<TIFR3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIFR3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIFR3_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIFR3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOV3` reader - Timer/Counter3 Overflow Flag"]
pub struct TOV3_R(crate::FieldReader<bool, bool>);
impl TOV3_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOV3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOV3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOV3` writer - Timer/Counter3 Overflow Flag"]
pub struct TOV3_W<'a> {
    w: &'a mut W,
}
impl<'a> TOV3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCF3A` reader - Output Compare Flag 3A"]
pub struct OCF3A_R(crate::FieldReader<bool, bool>);
impl OCF3A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF3A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF3A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF3A` writer - Output Compare Flag 3A"]
pub struct OCF3A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF3A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCF3B` reader - Output Compare Flag 3B"]
pub struct OCF3B_R(crate::FieldReader<bool, bool>);
impl OCF3B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF3B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF3B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF3B` writer - Output Compare Flag 3B"]
pub struct OCF3B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF3B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OCF3C` reader - Output Compare Flag 3C"]
pub struct OCF3C_R(crate::FieldReader<bool, bool>);
impl OCF3C_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF3C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF3C_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF3C` writer - Output Compare Flag 3C"]
pub struct OCF3C_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF3C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ICF3` reader - Input Capture Flag 3"]
pub struct ICF3_R(crate::FieldReader<bool, bool>);
impl ICF3_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICF3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICF3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICF3` writer - Input Capture Flag 3"]
pub struct ICF3_W<'a> {
    w: &'a mut W,
}
impl<'a> ICF3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter3 Overflow Flag"]
    #[inline(always)]
    pub fn tov3(&self) -> TOV3_R {
        TOV3_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Output Compare Flag 3A"]
    #[inline(always)]
    pub fn ocf3a(&self) -> OCF3A_R {
        OCF3A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Output Compare Flag 3B"]
    #[inline(always)]
    pub fn ocf3b(&self) -> OCF3B_R {
        OCF3B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Output Compare Flag 3C"]
    #[inline(always)]
    pub fn ocf3c(&self) -> OCF3C_R {
        OCF3C_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Input Capture Flag 3"]
    #[inline(always)]
    pub fn icf3(&self) -> ICF3_R {
        ICF3_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter3 Overflow Flag"]
    #[inline(always)]
    pub fn tov3(&mut self) -> TOV3_W {
        TOV3_W { w: self }
    }
    #[doc = "Bit 1 - Output Compare Flag 3A"]
    #[inline(always)]
    pub fn ocf3a(&mut self) -> OCF3A_W {
        OCF3A_W { w: self }
    }
    #[doc = "Bit 2 - Output Compare Flag 3B"]
    #[inline(always)]
    pub fn ocf3b(&mut self) -> OCF3B_W {
        OCF3B_W { w: self }
    }
    #[doc = "Bit 3 - Output Compare Flag 3C"]
    #[inline(always)]
    pub fn ocf3c(&mut self) -> OCF3C_W {
        OCF3C_W { w: self }
    }
    #[doc = "Bit 5 - Input Capture Flag 3"]
    #[inline(always)]
    pub fn icf3(&mut self) -> ICF3_W {
        ICF3_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter3 Interrupt Flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tifr3](index.html) module"]
pub struct TIFR3_SPEC;
impl crate::RegisterSpec for TIFR3_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tifr3::R](R) reader structure"]
impl crate::Readable for TIFR3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tifr3::W](W) writer structure"]
impl crate::Writable for TIFR3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIFR3 to value 0"]
impl crate::Resettable for TIFR3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
