#[doc = "Register `CLKPR` reader"]
pub struct R(crate::R<CLKPR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CLKPR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CLKPR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CLKPR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CLKPR` writer"]
pub struct W(crate::W<CLKPR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CLKPR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CLKPR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CLKPR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "No Description.\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CLKPS_A {
    #[doc = "0: 1"]
    VAL_0X00 = 0,
    #[doc = "1: 2"]
    VAL_0X01 = 1,
    #[doc = "2: 4"]
    VAL_0X02 = 2,
    #[doc = "3: 8"]
    VAL_0X03 = 3,
    #[doc = "4: 16"]
    VAL_0X04 = 4,
    #[doc = "5: 32"]
    VAL_0X05 = 5,
    #[doc = "6: 64"]
    VAL_0X06 = 6,
    #[doc = "7: 128"]
    VAL_0X07 = 7,
    #[doc = "8: 256"]
    VAL_0X08 = 8,
}
impl From<CLKPS_A> for u8 {
    #[inline(always)]
    fn from(variant: CLKPS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CLKPS` reader - No Description."]
pub struct CLKPS_R(crate::FieldReader<u8, CLKPS_A>);
impl CLKPS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CLKPS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CLKPS_A> {
        match self.bits {
            0 => Some(CLKPS_A::VAL_0X00),
            1 => Some(CLKPS_A::VAL_0X01),
            2 => Some(CLKPS_A::VAL_0X02),
            3 => Some(CLKPS_A::VAL_0X03),
            4 => Some(CLKPS_A::VAL_0X04),
            5 => Some(CLKPS_A::VAL_0X05),
            6 => Some(CLKPS_A::VAL_0X06),
            7 => Some(CLKPS_A::VAL_0X07),
            8 => Some(CLKPS_A::VAL_0X08),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == CLKPS_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == CLKPS_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == CLKPS_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == CLKPS_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == CLKPS_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == CLKPS_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == CLKPS_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == CLKPS_A::VAL_0X07
    }
    #[doc = "Checks if the value of the field is `VAL_0X08`"]
    #[inline(always)]
    pub fn is_val_0x08(&self) -> bool {
        **self == CLKPS_A::VAL_0X08
    }
}
impl core::ops::Deref for CLKPS_R {
    type Target = crate::FieldReader<u8, CLKPS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKPS` writer - No Description."]
pub struct CLKPS_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKPS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CLKPS_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "1"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X00)
    }
    #[doc = "2"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X01)
    }
    #[doc = "4"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X02)
    }
    #[doc = "8"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X03)
    }
    #[doc = "16"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X04)
    }
    #[doc = "32"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X05)
    }
    #[doc = "64"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X06)
    }
    #[doc = "128"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X07)
    }
    #[doc = "256"]
    #[inline(always)]
    pub fn val_0x08(self) -> &'a mut W {
        self.variant(CLKPS_A::VAL_0X08)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `CLKPCE` reader - No Description."]
pub struct CLKPCE_R(crate::FieldReader<bool, bool>);
impl CLKPCE_R {
    pub(crate) fn new(bits: bool) -> Self {
        CLKPCE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKPCE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKPCE` writer - No Description."]
pub struct CLKPCE_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKPCE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - No Description."]
    #[inline(always)]
    pub fn clkps(&self) -> CLKPS_R {
        CLKPS_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bit 7 - No Description."]
    #[inline(always)]
    pub fn clkpce(&self) -> CLKPCE_R {
        CLKPCE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - No Description."]
    #[inline(always)]
    pub fn clkps(&mut self) -> CLKPS_W {
        CLKPS_W { w: self }
    }
    #[doc = "Bit 7 - No Description."]
    #[inline(always)]
    pub fn clkpce(&mut self) -> CLKPCE_W {
        CLKPCE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [clkpr](index.html) module"]
pub struct CLKPR_SPEC;
impl crate::RegisterSpec for CLKPR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [clkpr::R](R) reader structure"]
impl crate::Readable for CLKPR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [clkpr::W](W) writer structure"]
impl crate::Writable for CLKPR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CLKPR to value 0"]
impl crate::Resettable for CLKPR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
