#[doc = "Register `DIDR0` reader"]
pub struct R(crate::R<DIDR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DIDR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DIDR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DIDR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DIDR0` writer"]
pub struct W(crate::W<DIDR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DIDR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DIDR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DIDR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ADC0D` reader - No Description."]
pub struct ADC0D_R(crate::FieldReader<bool, bool>);
impl ADC0D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC0D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC0D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC0D` writer - No Description."]
pub struct ADC0D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC0D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `ADC1D` reader - No Description."]
pub struct ADC1D_R(crate::FieldReader<bool, bool>);
impl ADC1D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC1D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC1D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC1D` writer - No Description."]
pub struct ADC1D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC1D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `ADC2D` reader - No Description."]
pub struct ADC2D_R(crate::FieldReader<bool, bool>);
impl ADC2D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC2D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC2D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC2D` writer - No Description."]
pub struct ADC2D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC2D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ADC3D` reader - No Description."]
pub struct ADC3D_R(crate::FieldReader<bool, bool>);
impl ADC3D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC3D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC3D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC3D` writer - No Description."]
pub struct ADC3D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC3D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ADC4D` reader - No Description."]
pub struct ADC4D_R(crate::FieldReader<bool, bool>);
impl ADC4D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC4D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC4D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC4D` writer - No Description."]
pub struct ADC4D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC4D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ADC5D` reader - No Description."]
pub struct ADC5D_R(crate::FieldReader<bool, bool>);
impl ADC5D_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC5D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC5D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC5D` writer - No Description."]
pub struct ADC5D_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC5D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn adc0d(&self) -> ADC0D_R {
        ADC0D_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn adc1d(&self) -> ADC1D_R {
        ADC1D_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - No Description."]
    #[inline(always)]
    pub fn adc2d(&self) -> ADC2D_R {
        ADC2D_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - No Description."]
    #[inline(always)]
    pub fn adc3d(&self) -> ADC3D_R {
        ADC3D_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - No Description."]
    #[inline(always)]
    pub fn adc4d(&self) -> ADC4D_R {
        ADC4D_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - No Description."]
    #[inline(always)]
    pub fn adc5d(&self) -> ADC5D_R {
        ADC5D_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn adc0d(&mut self) -> ADC0D_W {
        ADC0D_W { w: self }
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn adc1d(&mut self) -> ADC1D_W {
        ADC1D_W { w: self }
    }
    #[doc = "Bit 2 - No Description."]
    #[inline(always)]
    pub fn adc2d(&mut self) -> ADC2D_W {
        ADC2D_W { w: self }
    }
    #[doc = "Bit 3 - No Description."]
    #[inline(always)]
    pub fn adc3d(&mut self) -> ADC3D_W {
        ADC3D_W { w: self }
    }
    #[doc = "Bit 4 - No Description."]
    #[inline(always)]
    pub fn adc4d(&mut self) -> ADC4D_W {
        ADC4D_W { w: self }
    }
    #[doc = "Bit 5 - No Description."]
    #[inline(always)]
    pub fn adc5d(&mut self) -> ADC5D_W {
        ADC5D_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Digital Input Disable Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [didr0](index.html) module"]
pub struct DIDR0_SPEC;
impl crate::RegisterSpec for DIDR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [didr0::R](R) reader structure"]
impl crate::Readable for DIDR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [didr0::W](W) writer structure"]
impl crate::Writable for DIDR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DIDR0 to value 0"]
impl crate::Resettable for DIDR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
