#[doc = "Register `UCSR1C` reader"]
pub struct R(crate::R<UCSR1C_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR1C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR1C_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR1C_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR1C` writer"]
pub struct W(crate::W<UCSR1C_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR1C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR1C_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR1C_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `UCPOL1` reader - Clock Polarity"]
pub struct UCPOL1_R(crate::FieldReader<bool, bool>);
impl UCPOL1_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCPOL1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCPOL1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCPOL1` writer - Clock Polarity"]
pub struct UCPOL1_W<'a> {
    w: &'a mut W,
}
impl<'a> UCPOL1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `UCPHA1` reader - Clock Phase"]
pub struct UCPHA1_R(crate::FieldReader<bool, bool>);
impl UCPHA1_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCPHA1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCPHA1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCPHA1` writer - Clock Phase"]
pub struct UCPHA1_W<'a> {
    w: &'a mut W,
}
impl<'a> UCPHA1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `UDORD1` reader - Data Order"]
pub struct UDORD1_R(crate::FieldReader<bool, bool>);
impl UDORD1_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDORD1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDORD1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDORD1` writer - Data Order"]
pub struct UDORD1_W<'a> {
    w: &'a mut W,
}
impl<'a> UDORD1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol1(&self) -> UCPOL1_R {
        UCPOL1_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Clock Phase"]
    #[inline(always)]
    pub fn ucpha1(&self) -> UCPHA1_R {
        UCPHA1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Data Order"]
    #[inline(always)]
    pub fn udord1(&self) -> UDORD1_R {
        UDORD1_R::new(((self.bits >> 2) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol1(&mut self) -> UCPOL1_W {
        UCPOL1_W { w: self }
    }
    #[doc = "Bit 1 - Clock Phase"]
    #[inline(always)]
    pub fn ucpha1(&mut self) -> UCPHA1_W {
        UCPHA1_W { w: self }
    }
    #[doc = "Bit 2 - Data Order"]
    #[inline(always)]
    pub fn udord1(&mut self) -> UDORD1_W {
        UDORD1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART1 MSPIM Control and Status Register C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr1c](index.html) module"]
pub struct UCSR1C_SPEC;
impl crate::RegisterSpec for UCSR1C_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr1c::R](R) reader structure"]
impl crate::Readable for UCSR1C_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr1c::W](W) writer structure"]
impl crate::Writable for UCSR1C_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR1C to value 0"]
impl crate::Resettable for UCSR1C_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
