#[doc = "Register `UCSR1B` reader"]
pub struct R(crate::R<UCSR1B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR1B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR1B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR1B` writer"]
pub struct W(crate::W<UCSR1B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR1B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR1B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXEN1` reader - Transmitter Enable"]
pub struct TXEN1_R(crate::FieldReader<bool, bool>);
impl TXEN1_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXEN1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXEN1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXEN1` writer - Transmitter Enable"]
pub struct TXEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> TXEN1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXEN1` reader - Receiver Enable"]
pub struct RXEN1_R(crate::FieldReader<bool, bool>);
impl RXEN1_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXEN1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXEN1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXEN1` writer - Receiver Enable"]
pub struct RXEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> RXEN1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `UDRIE1` reader - USART Data Register Empty Interrupt Enable"]
pub struct UDRIE1_R(crate::FieldReader<bool, bool>);
impl UDRIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRIE1` writer - USART Data Register Empty Interrupt Enable"]
pub struct UDRIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> UDRIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXCIE1` reader - TX Complete Interrupt Enable"]
pub struct TXCIE1_R(crate::FieldReader<bool, bool>);
impl TXCIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIE1` writer - TX Complete Interrupt Enable"]
pub struct TXCIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIE1` reader - RX Complete Interrupt Enable"]
pub struct RXCIE1_R(crate::FieldReader<bool, bool>);
impl RXCIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIE1` writer - RX Complete Interrupt Enable"]
pub struct RXCIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> RXCIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen1(&self) -> TXEN1_R {
        TXEN1_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen1(&self) -> RXEN1_R {
        RXEN1_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - USART Data Register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie1(&self) -> UDRIE1_R {
        UDRIE1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie1(&self) -> TXCIE1_R {
        TXCIE1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie1(&self) -> RXCIE1_R {
        RXCIE1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen1(&mut self) -> TXEN1_W {
        TXEN1_W { w: self }
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen1(&mut self) -> RXEN1_W {
        RXEN1_W { w: self }
    }
    #[doc = "Bit 5 - USART Data Register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie1(&mut self) -> UDRIE1_W {
        UDRIE1_W { w: self }
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie1(&mut self) -> TXCIE1_W {
        TXCIE1_W { w: self }
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie1(&mut self) -> RXCIE1_W {
        RXCIE1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART1 MSPIM Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr1b](index.html) module"]
pub struct UCSR1B_SPEC;
impl crate::RegisterSpec for UCSR1B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr1b::R](R) reader structure"]
impl crate::Readable for UCSR1B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr1b::W](W) writer structure"]
impl crate::Writable for UCSR1B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR1B to value 0"]
impl crate::Resettable for UCSR1B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
