#[doc = "Register `UCSR1A` reader"]
pub struct R(crate::R<UCSR1A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR1A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR1A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR1A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR1A` writer"]
pub struct W(crate::W<UCSR1A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR1A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR1A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR1A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `UDRE1` reader - USART Data Register Empty"]
pub struct UDRE1_R(crate::FieldReader<bool, bool>);
impl UDRE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRE1` writer - USART Data Register Empty"]
pub struct UDRE1_W<'a> {
    w: &'a mut W,
}
impl<'a> UDRE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXC1` reader - USART Transmit Complete"]
pub struct TXC1_R(crate::FieldReader<bool, bool>);
impl TXC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXC1` writer - USART Transmit Complete"]
pub struct TXC1_W<'a> {
    w: &'a mut W,
}
impl<'a> TXC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXC1` reader - USART Receive Complete"]
pub struct RXC1_R(crate::FieldReader<bool, bool>);
impl RXC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXC1` writer - USART Receive Complete"]
pub struct RXC1_W<'a> {
    w: &'a mut W,
}
impl<'a> RXC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 5 - USART Data Register Empty"]
    #[inline(always)]
    pub fn udre1(&self) -> UDRE1_R {
        UDRE1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - USART Transmit Complete"]
    #[inline(always)]
    pub fn txc1(&self) -> TXC1_R {
        TXC1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - USART Receive Complete"]
    #[inline(always)]
    pub fn rxc1(&self) -> RXC1_R {
        RXC1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 5 - USART Data Register Empty"]
    #[inline(always)]
    pub fn udre1(&mut self) -> UDRE1_W {
        UDRE1_W { w: self }
    }
    #[doc = "Bit 6 - USART Transmit Complete"]
    #[inline(always)]
    pub fn txc1(&mut self) -> TXC1_W {
        TXC1_W { w: self }
    }
    #[doc = "Bit 7 - USART Receive Complete"]
    #[inline(always)]
    pub fn rxc1(&mut self) -> RXC1_W {
        RXC1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART1 MSPIM Control and Status Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr1a](index.html) module"]
pub struct UCSR1A_SPEC;
impl crate::RegisterSpec for UCSR1A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr1a::R](R) reader structure"]
impl crate::Readable for UCSR1A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr1a::W](W) writer structure"]
impl crate::Writable for UCSR1A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR1A to value 0"]
impl crate::Resettable for UCSR1A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
