#[doc = "Register `UCSR0B` reader"]
pub struct R(crate::R<UCSR0B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR0B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR0B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR0B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR0B` writer"]
pub struct W(crate::W<UCSR0B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR0B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR0B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR0B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXB80` reader - Transmit Data Bit 8"]
pub struct TXB80_R(crate::FieldReader<bool, bool>);
impl TXB80_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXB80_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXB80_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXB80` writer - Transmit Data Bit 8"]
pub struct TXB80_W<'a> {
    w: &'a mut W,
}
impl<'a> TXB80_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `RXB80` reader - Receive Data Bit 8"]
pub struct RXB80_R(crate::FieldReader<bool, bool>);
impl RXB80_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXB80_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXB80_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ02` reader - Character Size"]
pub struct UCSZ02_R(crate::FieldReader<bool, bool>);
impl UCSZ02_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCSZ02_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCSZ02_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ02` writer - Character Size"]
pub struct UCSZ02_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ02_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TXEN0` reader - Transmitter Enable"]
pub struct TXEN0_R(crate::FieldReader<bool, bool>);
impl TXEN0_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXEN0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXEN0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXEN0` writer - Transmitter Enable"]
pub struct TXEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> TXEN0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXEN0` reader - Receiver Enable"]
pub struct RXEN0_R(crate::FieldReader<bool, bool>);
impl RXEN0_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXEN0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXEN0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXEN0` writer - Receiver Enable"]
pub struct RXEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> RXEN0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `UDRIE0` reader - USART Data Register Empty Interrupt Enable"]
pub struct UDRIE0_R(crate::FieldReader<bool, bool>);
impl UDRIE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRIE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRIE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRIE0` writer - USART Data Register Empty Interrupt Enable"]
pub struct UDRIE0_W<'a> {
    w: &'a mut W,
}
impl<'a> UDRIE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXCIE0` reader - TX Complete Interrupt Enable"]
pub struct TXCIE0_R(crate::FieldReader<bool, bool>);
impl TXCIE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIE0` writer - TX Complete Interrupt Enable"]
pub struct TXCIE0_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIE0` reader - RX Complete Interrupt Enable"]
pub struct RXCIE0_R(crate::FieldReader<bool, bool>);
impl RXCIE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIE0` writer - RX Complete Interrupt Enable"]
pub struct RXCIE0_W<'a> {
    w: &'a mut W,
}
impl<'a> RXCIE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb80(&self) -> TXB80_R {
        TXB80_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Receive Data Bit 8"]
    #[inline(always)]
    pub fn rxb80(&self) -> RXB80_R {
        RXB80_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz02(&self) -> UCSZ02_R {
        UCSZ02_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen0(&self) -> TXEN0_R {
        TXEN0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen0(&self) -> RXEN0_R {
        RXEN0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - USART Data Register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie0(&self) -> UDRIE0_R {
        UDRIE0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie0(&self) -> TXCIE0_R {
        TXCIE0_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie0(&self) -> RXCIE0_R {
        RXCIE0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb80(&mut self) -> TXB80_W {
        TXB80_W { w: self }
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz02(&mut self) -> UCSZ02_W {
        UCSZ02_W { w: self }
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen0(&mut self) -> TXEN0_W {
        TXEN0_W { w: self }
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen0(&mut self) -> RXEN0_W {
        RXEN0_W { w: self }
    }
    #[doc = "Bit 5 - USART Data Register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie0(&mut self) -> UDRIE0_W {
        UDRIE0_W { w: self }
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie0(&mut self) -> TXCIE0_W {
        TXCIE0_W { w: self }
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie0(&mut self) -> RXCIE0_W {
        RXCIE0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART0 Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr0b](index.html) module"]
pub struct UCSR0B_SPEC;
impl crate::RegisterSpec for UCSR0B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr0b::R](R) reader structure"]
impl crate::Readable for UCSR0B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr0b::W](W) writer structure"]
impl crate::Writable for UCSR0B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR0B to value 0"]
impl crate::Resettable for UCSR0B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
