#[doc = "Register `TWAR` reader"]
pub struct R(crate::R<TWAR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWAR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWAR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWAR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWAR` writer"]
pub struct W(crate::W<TWAR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWAR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWAR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWAR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWGCE` reader - TWI General Call Recognition Enable Bit"]
pub struct TWGCE_R(crate::FieldReader<bool, bool>);
impl TWGCE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWGCE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWGCE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWGCE` writer - TWI General Call Recognition Enable Bit"]
pub struct TWGCE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWGCE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TWA` reader - TWI (Slave) Address"]
pub struct TWA_R(crate::FieldReader<u8, u8>);
impl TWA_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWA` writer - TWI (Slave) Address"]
pub struct TWA_W<'a> {
    w: &'a mut W,
}
impl<'a> TWA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 1)) | ((value as u8 & 0x7f) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - TWI General Call Recognition Enable Bit"]
    #[inline(always)]
    pub fn twgce(&self) -> TWGCE_R {
        TWGCE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:7 - TWI (Slave) Address"]
    #[inline(always)]
    pub fn twa(&self) -> TWA_R {
        TWA_R::new(((self.bits >> 1) & 0x7f) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - TWI General Call Recognition Enable Bit"]
    #[inline(always)]
    pub fn twgce(&mut self) -> TWGCE_W {
        TWGCE_W { w: self }
    }
    #[doc = "Bits 1:7 - TWI (Slave) Address"]
    #[inline(always)]
    pub fn twa(&mut self) -> TWA_W {
        TWA_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI (Slave) Address Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twar](index.html) module"]
pub struct TWAR_SPEC;
impl crate::RegisterSpec for TWAR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twar::R](R) reader structure"]
impl crate::Readable for TWAR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twar::W](W) writer structure"]
impl crate::Writable for TWAR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWAR to value 0"]
impl crate::Resettable for TWAR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
