#[doc = "Register `VREG_CTRL` reader"]
pub struct R(crate::R<VREG_CTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<VREG_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<VREG_CTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<VREG_CTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `VREG_CTRL` writer"]
pub struct W(crate::W<VREG_CTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<VREG_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<VREG_CTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<VREG_CTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "DVDD Supply Voltage Valid\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum DVDD_OK_A {
    #[doc = "0: Digital voltage regulator disabled or supply voltage not stable"]
    DIGITAL_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE = 0,
    #[doc = "1: Digital supply voltage has settled"]
    DIGITAL_SUPPLY_VOLTAGE_HAS_SETTLED = 1,
}
impl From<DVDD_OK_A> for bool {
    #[inline(always)]
    fn from(variant: DVDD_OK_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `DVDD_OK` reader - DVDD Supply Voltage Valid"]
pub struct DVDD_OK_R(crate::FieldReader<bool, DVDD_OK_A>);
impl DVDD_OK_R {
    pub(crate) fn new(bits: bool) -> Self {
        DVDD_OK_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DVDD_OK_A {
        match self.bits {
            false => DVDD_OK_A::DIGITAL_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE,
            true => DVDD_OK_A::DIGITAL_SUPPLY_VOLTAGE_HAS_SETTLED,
        }
    }
    #[doc = "Checks if the value of the field is `DIGITAL_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE`"]
    #[inline(always)]
    pub fn is_digital_voltage_regulator_disabled_or_supply_voltage_not_stable(&self) -> bool {
        **self == DVDD_OK_A::DIGITAL_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE
    }
    #[doc = "Checks if the value of the field is `DIGITAL_SUPPLY_VOLTAGE_HAS_SETTLED`"]
    #[inline(always)]
    pub fn is_digital_supply_voltage_has_settled(&self) -> bool {
        **self == DVDD_OK_A::DIGITAL_SUPPLY_VOLTAGE_HAS_SETTLED
    }
}
impl core::ops::Deref for DVDD_OK_R {
    type Target = crate::FieldReader<bool, DVDD_OK_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DVDD_OK` writer - DVDD Supply Voltage Valid"]
pub struct DVDD_OK_W<'a> {
    w: &'a mut W,
}
impl<'a> DVDD_OK_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DVDD_OK_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Digital voltage regulator disabled or supply voltage not stable"]
    #[inline(always)]
    pub fn digital_voltage_regulator_disabled_or_supply_voltage_not_stable(self) -> &'a mut W {
        self.variant(DVDD_OK_A::DIGITAL_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE)
    }
    #[doc = "Digital supply voltage has settled"]
    #[inline(always)]
    pub fn digital_supply_voltage_has_settled(self) -> &'a mut W {
        self.variant(DVDD_OK_A::DIGITAL_SUPPLY_VOLTAGE_HAS_SETTLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Use External DVDD Regulator\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum DVREG_EXT_A {
    #[doc = "0: Internal DVDD voltage regulator for the digital section is enabled."]
    DVDD_INT = 0,
    #[doc = "1: Internal DVDD voltage regulator is disabled; use external regulated 1.8V supply voltage for the digital section."]
    DVDD_EXT = 1,
}
impl From<DVREG_EXT_A> for bool {
    #[inline(always)]
    fn from(variant: DVREG_EXT_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `DVREG_EXT` reader - Use External DVDD Regulator"]
pub struct DVREG_EXT_R(crate::FieldReader<bool, DVREG_EXT_A>);
impl DVREG_EXT_R {
    pub(crate) fn new(bits: bool) -> Self {
        DVREG_EXT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DVREG_EXT_A {
        match self.bits {
            false => DVREG_EXT_A::DVDD_INT,
            true => DVREG_EXT_A::DVDD_EXT,
        }
    }
    #[doc = "Checks if the value of the field is `DVDD_INT`"]
    #[inline(always)]
    pub fn is_dvdd_int(&self) -> bool {
        **self == DVREG_EXT_A::DVDD_INT
    }
    #[doc = "Checks if the value of the field is `DVDD_EXT`"]
    #[inline(always)]
    pub fn is_dvdd_ext(&self) -> bool {
        **self == DVREG_EXT_A::DVDD_EXT
    }
}
impl core::ops::Deref for DVREG_EXT_R {
    type Target = crate::FieldReader<bool, DVREG_EXT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DVREG_EXT` writer - Use External DVDD Regulator"]
pub struct DVREG_EXT_W<'a> {
    w: &'a mut W,
}
impl<'a> DVREG_EXT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DVREG_EXT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Internal DVDD voltage regulator for the digital section is enabled."]
    #[inline(always)]
    pub fn dvdd_int(self) -> &'a mut W {
        self.variant(DVREG_EXT_A::DVDD_INT)
    }
    #[doc = "Internal DVDD voltage regulator is disabled; use external regulated 1.8V supply voltage for the digital section."]
    #[inline(always)]
    pub fn dvdd_ext(self) -> &'a mut W {
        self.variant(DVREG_EXT_A::DVDD_EXT)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "AVDD Supply Voltage Valid\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum AVDD_OK_A {
    #[doc = "0: Analog voltage regulator disabled or supply voltage not stable"]
    ANALOG_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE = 0,
    #[doc = "1: Analog supply voltage has settled"]
    ANALOG_SUPPLY_VOLTAGE_HAS_SETTLED = 1,
}
impl From<AVDD_OK_A> for bool {
    #[inline(always)]
    fn from(variant: AVDD_OK_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `AVDD_OK` reader - AVDD Supply Voltage Valid"]
pub struct AVDD_OK_R(crate::FieldReader<bool, AVDD_OK_A>);
impl AVDD_OK_R {
    pub(crate) fn new(bits: bool) -> Self {
        AVDD_OK_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AVDD_OK_A {
        match self.bits {
            false => AVDD_OK_A::ANALOG_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE,
            true => AVDD_OK_A::ANALOG_SUPPLY_VOLTAGE_HAS_SETTLED,
        }
    }
    #[doc = "Checks if the value of the field is `ANALOG_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE`"]
    #[inline(always)]
    pub fn is_analog_voltage_regulator_disabled_or_supply_voltage_not_stable(&self) -> bool {
        **self == AVDD_OK_A::ANALOG_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE
    }
    #[doc = "Checks if the value of the field is `ANALOG_SUPPLY_VOLTAGE_HAS_SETTLED`"]
    #[inline(always)]
    pub fn is_analog_supply_voltage_has_settled(&self) -> bool {
        **self == AVDD_OK_A::ANALOG_SUPPLY_VOLTAGE_HAS_SETTLED
    }
}
impl core::ops::Deref for AVDD_OK_R {
    type Target = crate::FieldReader<bool, AVDD_OK_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AVDD_OK` writer - AVDD Supply Voltage Valid"]
pub struct AVDD_OK_W<'a> {
    w: &'a mut W,
}
impl<'a> AVDD_OK_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AVDD_OK_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Analog voltage regulator disabled or supply voltage not stable"]
    #[inline(always)]
    pub fn analog_voltage_regulator_disabled_or_supply_voltage_not_stable(self) -> &'a mut W {
        self.variant(AVDD_OK_A::ANALOG_VOLTAGE_REGULATOR_DISABLED_OR_SUPPLY_VOLTAGE_NOT_STABLE)
    }
    #[doc = "Analog supply voltage has settled"]
    #[inline(always)]
    pub fn analog_supply_voltage_has_settled(self) -> &'a mut W {
        self.variant(AVDD_OK_A::ANALOG_SUPPLY_VOLTAGE_HAS_SETTLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Use External AVDD Regulator\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum AVREG_EXT_A {
    #[doc = "0: Internal AVDD voltage regulator for the analog section is enabled."]
    AVDD_INT = 0,
    #[doc = "1: Internal AVDD voltage regulator is disabled; use external regulated 1.8V supply voltage for the analog section."]
    AVDD_EXT = 1,
}
impl From<AVREG_EXT_A> for bool {
    #[inline(always)]
    fn from(variant: AVREG_EXT_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `AVREG_EXT` reader - Use External AVDD Regulator"]
pub struct AVREG_EXT_R(crate::FieldReader<bool, AVREG_EXT_A>);
impl AVREG_EXT_R {
    pub(crate) fn new(bits: bool) -> Self {
        AVREG_EXT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AVREG_EXT_A {
        match self.bits {
            false => AVREG_EXT_A::AVDD_INT,
            true => AVREG_EXT_A::AVDD_EXT,
        }
    }
    #[doc = "Checks if the value of the field is `AVDD_INT`"]
    #[inline(always)]
    pub fn is_avdd_int(&self) -> bool {
        **self == AVREG_EXT_A::AVDD_INT
    }
    #[doc = "Checks if the value of the field is `AVDD_EXT`"]
    #[inline(always)]
    pub fn is_avdd_ext(&self) -> bool {
        **self == AVREG_EXT_A::AVDD_EXT
    }
}
impl core::ops::Deref for AVREG_EXT_R {
    type Target = crate::FieldReader<bool, AVREG_EXT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AVREG_EXT` writer - Use External AVDD Regulator"]
pub struct AVREG_EXT_W<'a> {
    w: &'a mut W,
}
impl<'a> AVREG_EXT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AVREG_EXT_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Internal AVDD voltage regulator for the analog section is enabled."]
    #[inline(always)]
    pub fn avdd_int(self) -> &'a mut W {
        self.variant(AVREG_EXT_A::AVDD_INT)
    }
    #[doc = "Internal AVDD voltage regulator is disabled; use external regulated 1.8V supply voltage for the analog section."]
    #[inline(always)]
    pub fn avdd_ext(self) -> &'a mut W {
        self.variant(AVREG_EXT_A::AVDD_EXT)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - DVDD Supply Voltage Valid"]
    #[inline(always)]
    pub fn dvdd_ok(&self) -> DVDD_OK_R {
        DVDD_OK_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Use External DVDD Regulator"]
    #[inline(always)]
    pub fn dvreg_ext(&self) -> DVREG_EXT_R {
        DVREG_EXT_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 6 - AVDD Supply Voltage Valid"]
    #[inline(always)]
    pub fn avdd_ok(&self) -> AVDD_OK_R {
        AVDD_OK_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Use External AVDD Regulator"]
    #[inline(always)]
    pub fn avreg_ext(&self) -> AVREG_EXT_R {
        AVREG_EXT_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - DVDD Supply Voltage Valid"]
    #[inline(always)]
    pub fn dvdd_ok(&mut self) -> DVDD_OK_W {
        DVDD_OK_W { w: self }
    }
    #[doc = "Bit 3 - Use External DVDD Regulator"]
    #[inline(always)]
    pub fn dvreg_ext(&mut self) -> DVREG_EXT_W {
        DVREG_EXT_W { w: self }
    }
    #[doc = "Bit 6 - AVDD Supply Voltage Valid"]
    #[inline(always)]
    pub fn avdd_ok(&mut self) -> AVDD_OK_W {
        AVDD_OK_W { w: self }
    }
    #[doc = "Bit 7 - Use External AVDD Regulator"]
    #[inline(always)]
    pub fn avreg_ext(&mut self) -> AVREG_EXT_W {
        AVREG_EXT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Voltage Regulator Control and Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [vreg_ctrl](index.html) module"]
pub struct VREG_CTRL_SPEC;
impl crate::RegisterSpec for VREG_CTRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [vreg_ctrl::R](R) reader structure"]
impl crate::Readable for VREG_CTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [vreg_ctrl::W](W) writer structure"]
impl crate::Writable for VREG_CTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets VREG_CTRL to value 0"]
impl crate::Resettable for VREG_CTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
