#[doc = "Register `TRX_STATE` reader"]
pub struct R(crate::R<TRX_STATE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TRX_STATE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TRX_STATE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TRX_STATE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TRX_STATE` writer"]
pub struct W(crate::W<TRX_STATE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TRX_STATE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TRX_STATE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TRX_STATE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "State Control Command\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum TRX_CMD_A {
    #[doc = "0: NOP"]
    CMD_NOP = 0,
    #[doc = "2: TX_START"]
    CMD_TX_START = 2,
    #[doc = "3: FORCE_TRX_OFF"]
    CMD_FORCE_TRX_OFF = 3,
    #[doc = "4: FORCE_PLL_ON"]
    CMD_FORCE_PLL_ON = 4,
    #[doc = "6: RX_ON"]
    CMD_RX_ON = 6,
    #[doc = "8: TRX_OFF"]
    CMD_TRX_OFF = 8,
    #[doc = "9: PLL_ON (TX_ON)"]
    CMD_PLL_ON = 9,
    #[doc = "22: RX_AACK_ON"]
    CMD_RX_AACK_ON = 22,
    #[doc = "25: TX_ARET_ON"]
    CMD_TX_ARET_ON = 25,
}
impl From<TRX_CMD_A> for u8 {
    #[inline(always)]
    fn from(variant: TRX_CMD_A) -> Self {
        variant as _
    }
}
#[doc = "Field `TRX_CMD` reader - State Control Command"]
pub struct TRX_CMD_R(crate::FieldReader<u8, TRX_CMD_A>);
impl TRX_CMD_R {
    pub(crate) fn new(bits: u8) -> Self {
        TRX_CMD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<TRX_CMD_A> {
        match self.bits {
            0 => Some(TRX_CMD_A::CMD_NOP),
            2 => Some(TRX_CMD_A::CMD_TX_START),
            3 => Some(TRX_CMD_A::CMD_FORCE_TRX_OFF),
            4 => Some(TRX_CMD_A::CMD_FORCE_PLL_ON),
            6 => Some(TRX_CMD_A::CMD_RX_ON),
            8 => Some(TRX_CMD_A::CMD_TRX_OFF),
            9 => Some(TRX_CMD_A::CMD_PLL_ON),
            22 => Some(TRX_CMD_A::CMD_RX_AACK_ON),
            25 => Some(TRX_CMD_A::CMD_TX_ARET_ON),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `CMD_NOP`"]
    #[inline(always)]
    pub fn is_cmd_nop(&self) -> bool {
        **self == TRX_CMD_A::CMD_NOP
    }
    #[doc = "Checks if the value of the field is `CMD_TX_START`"]
    #[inline(always)]
    pub fn is_cmd_tx_start(&self) -> bool {
        **self == TRX_CMD_A::CMD_TX_START
    }
    #[doc = "Checks if the value of the field is `CMD_FORCE_TRX_OFF`"]
    #[inline(always)]
    pub fn is_cmd_force_trx_off(&self) -> bool {
        **self == TRX_CMD_A::CMD_FORCE_TRX_OFF
    }
    #[doc = "Checks if the value of the field is `CMD_FORCE_PLL_ON`"]
    #[inline(always)]
    pub fn is_cmd_force_pll_on(&self) -> bool {
        **self == TRX_CMD_A::CMD_FORCE_PLL_ON
    }
    #[doc = "Checks if the value of the field is `CMD_RX_ON`"]
    #[inline(always)]
    pub fn is_cmd_rx_on(&self) -> bool {
        **self == TRX_CMD_A::CMD_RX_ON
    }
    #[doc = "Checks if the value of the field is `CMD_TRX_OFF`"]
    #[inline(always)]
    pub fn is_cmd_trx_off(&self) -> bool {
        **self == TRX_CMD_A::CMD_TRX_OFF
    }
    #[doc = "Checks if the value of the field is `CMD_PLL_ON`"]
    #[inline(always)]
    pub fn is_cmd_pll_on(&self) -> bool {
        **self == TRX_CMD_A::CMD_PLL_ON
    }
    #[doc = "Checks if the value of the field is `CMD_RX_AACK_ON`"]
    #[inline(always)]
    pub fn is_cmd_rx_aack_on(&self) -> bool {
        **self == TRX_CMD_A::CMD_RX_AACK_ON
    }
    #[doc = "Checks if the value of the field is `CMD_TX_ARET_ON`"]
    #[inline(always)]
    pub fn is_cmd_tx_aret_on(&self) -> bool {
        **self == TRX_CMD_A::CMD_TX_ARET_ON
    }
}
impl core::ops::Deref for TRX_CMD_R {
    type Target = crate::FieldReader<u8, TRX_CMD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRX_CMD` writer - State Control Command"]
pub struct TRX_CMD_W<'a> {
    w: &'a mut W,
}
impl<'a> TRX_CMD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TRX_CMD_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "NOP"]
    #[inline(always)]
    pub fn cmd_nop(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_NOP)
    }
    #[doc = "TX_START"]
    #[inline(always)]
    pub fn cmd_tx_start(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_TX_START)
    }
    #[doc = "FORCE_TRX_OFF"]
    #[inline(always)]
    pub fn cmd_force_trx_off(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_FORCE_TRX_OFF)
    }
    #[doc = "FORCE_PLL_ON"]
    #[inline(always)]
    pub fn cmd_force_pll_on(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_FORCE_PLL_ON)
    }
    #[doc = "RX_ON"]
    #[inline(always)]
    pub fn cmd_rx_on(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_RX_ON)
    }
    #[doc = "TRX_OFF"]
    #[inline(always)]
    pub fn cmd_trx_off(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_TRX_OFF)
    }
    #[doc = "PLL_ON (TX_ON)"]
    #[inline(always)]
    pub fn cmd_pll_on(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_PLL_ON)
    }
    #[doc = "RX_AACK_ON"]
    #[inline(always)]
    pub fn cmd_rx_aack_on(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_RX_AACK_ON)
    }
    #[doc = "TX_ARET_ON"]
    #[inline(always)]
    pub fn cmd_tx_aret_on(self) -> &'a mut W {
        self.variant(TRX_CMD_A::CMD_TX_ARET_ON)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u8 & 0x1f);
        self.w
    }
}
#[doc = "Transaction Status\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum TRAC_STATUS_A {
    #[doc = "0: SUCCESS (RX_AACK, TX_ARET)"]
    TRAC_SUCCESS = 0,
    #[doc = "1: SUCCESS_DATA_PENDING (TX_ARET)"]
    TRAC_SUCCESS_DATA_PENDING = 1,
    #[doc = "2: SUCCESS_WAIT_FOR_ACK (RX_AACK)"]
    TRAC_SUCCESS_WAIT_FOR_ACK = 2,
    #[doc = "3: CHANNEL_ACCESS_FAILURE (TX_ARET)"]
    TRAC_CHANNEL_ACCESS_FAILURE = 3,
    #[doc = "5: NO_ACK (TX_ARET)"]
    TRAC_NO_ACK = 5,
    #[doc = "7: INVALID (RX_AACK, TX_ARET)"]
    TRAC_INVALID = 7,
}
impl From<TRAC_STATUS_A> for u8 {
    #[inline(always)]
    fn from(variant: TRAC_STATUS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `TRAC_STATUS` reader - Transaction Status"]
pub struct TRAC_STATUS_R(crate::FieldReader<u8, TRAC_STATUS_A>);
impl TRAC_STATUS_R {
    pub(crate) fn new(bits: u8) -> Self {
        TRAC_STATUS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<TRAC_STATUS_A> {
        match self.bits {
            0 => Some(TRAC_STATUS_A::TRAC_SUCCESS),
            1 => Some(TRAC_STATUS_A::TRAC_SUCCESS_DATA_PENDING),
            2 => Some(TRAC_STATUS_A::TRAC_SUCCESS_WAIT_FOR_ACK),
            3 => Some(TRAC_STATUS_A::TRAC_CHANNEL_ACCESS_FAILURE),
            5 => Some(TRAC_STATUS_A::TRAC_NO_ACK),
            7 => Some(TRAC_STATUS_A::TRAC_INVALID),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `TRAC_SUCCESS`"]
    #[inline(always)]
    pub fn is_trac_success(&self) -> bool {
        **self == TRAC_STATUS_A::TRAC_SUCCESS
    }
    #[doc = "Checks if the value of the field is `TRAC_SUCCESS_DATA_PENDING`"]
    #[inline(always)]
    pub fn is_trac_success_data_pending(&self) -> bool {
        **self == TRAC_STATUS_A::TRAC_SUCCESS_DATA_PENDING
    }
    #[doc = "Checks if the value of the field is `TRAC_SUCCESS_WAIT_FOR_ACK`"]
    #[inline(always)]
    pub fn is_trac_success_wait_for_ack(&self) -> bool {
        **self == TRAC_STATUS_A::TRAC_SUCCESS_WAIT_FOR_ACK
    }
    #[doc = "Checks if the value of the field is `TRAC_CHANNEL_ACCESS_FAILURE`"]
    #[inline(always)]
    pub fn is_trac_channel_access_failure(&self) -> bool {
        **self == TRAC_STATUS_A::TRAC_CHANNEL_ACCESS_FAILURE
    }
    #[doc = "Checks if the value of the field is `TRAC_NO_ACK`"]
    #[inline(always)]
    pub fn is_trac_no_ack(&self) -> bool {
        **self == TRAC_STATUS_A::TRAC_NO_ACK
    }
    #[doc = "Checks if the value of the field is `TRAC_INVALID`"]
    #[inline(always)]
    pub fn is_trac_invalid(&self) -> bool {
        **self == TRAC_STATUS_A::TRAC_INVALID
    }
}
impl core::ops::Deref for TRAC_STATUS_R {
    type Target = crate::FieldReader<u8, TRAC_STATUS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRAC_STATUS` writer - Transaction Status"]
pub struct TRAC_STATUS_W<'a> {
    w: &'a mut W,
}
impl<'a> TRAC_STATUS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TRAC_STATUS_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "SUCCESS (RX_AACK, TX_ARET)"]
    #[inline(always)]
    pub fn trac_success(self) -> &'a mut W {
        self.variant(TRAC_STATUS_A::TRAC_SUCCESS)
    }
    #[doc = "SUCCESS_DATA_PENDING (TX_ARET)"]
    #[inline(always)]
    pub fn trac_success_data_pending(self) -> &'a mut W {
        self.variant(TRAC_STATUS_A::TRAC_SUCCESS_DATA_PENDING)
    }
    #[doc = "SUCCESS_WAIT_FOR_ACK (RX_AACK)"]
    #[inline(always)]
    pub fn trac_success_wait_for_ack(self) -> &'a mut W {
        self.variant(TRAC_STATUS_A::TRAC_SUCCESS_WAIT_FOR_ACK)
    }
    #[doc = "CHANNEL_ACCESS_FAILURE (TX_ARET)"]
    #[inline(always)]
    pub fn trac_channel_access_failure(self) -> &'a mut W {
        self.variant(TRAC_STATUS_A::TRAC_CHANNEL_ACCESS_FAILURE)
    }
    #[doc = "NO_ACK (TX_ARET)"]
    #[inline(always)]
    pub fn trac_no_ack(self) -> &'a mut W {
        self.variant(TRAC_STATUS_A::TRAC_NO_ACK)
    }
    #[doc = "INVALID (RX_AACK, TX_ARET)"]
    #[inline(always)]
    pub fn trac_invalid(self) -> &'a mut W {
        self.variant(TRAC_STATUS_A::TRAC_INVALID)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u8 & 0x07) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - State Control Command"]
    #[inline(always)]
    pub fn trx_cmd(&self) -> TRX_CMD_R {
        TRX_CMD_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bits 5:7 - Transaction Status"]
    #[inline(always)]
    pub fn trac_status(&self) -> TRAC_STATUS_R {
        TRAC_STATUS_R::new(((self.bits >> 5) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:4 - State Control Command"]
    #[inline(always)]
    pub fn trx_cmd(&mut self) -> TRX_CMD_W {
        TRX_CMD_W { w: self }
    }
    #[doc = "Bits 5:7 - Transaction Status"]
    #[inline(always)]
    pub fn trac_status(&mut self) -> TRAC_STATUS_W {
        TRAC_STATUS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver State Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [trx_state](index.html) module"]
pub struct TRX_STATE_SPEC;
impl crate::RegisterSpec for TRX_STATE_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [trx_state::R](R) reader structure"]
impl crate::Readable for TRX_STATE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [trx_state::W](W) writer structure"]
impl crate::Writable for TRX_STATE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TRX_STATE to value 0"]
impl crate::Resettable for TRX_STATE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
