#[doc = "Register `TRX_CTRL_2` reader"]
pub struct R(crate::R<TRX_CTRL_2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TRX_CTRL_2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TRX_CTRL_2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TRX_CTRL_2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TRX_CTRL_2` writer"]
pub struct W(crate::W<TRX_CTRL_2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TRX_CTRL_2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TRX_CTRL_2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TRX_CTRL_2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Data Rate Selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum OQPSK_DATA_RATE_A {
    #[doc = "0: 250 kb/s (IEEE 802.15.4 compliant)"]
    RATE_250KB = 0,
    #[doc = "1: 500 kb/s"]
    RATE_500KB = 1,
    #[doc = "2: 1000 kb/s"]
    RATE_1000KB = 2,
    #[doc = "3: 2000 kb/s"]
    RATE_2000KB = 3,
}
impl From<OQPSK_DATA_RATE_A> for u8 {
    #[inline(always)]
    fn from(variant: OQPSK_DATA_RATE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `OQPSK_DATA_RATE` reader - Data Rate Selection"]
pub struct OQPSK_DATA_RATE_R(crate::FieldReader<u8, OQPSK_DATA_RATE_A>);
impl OQPSK_DATA_RATE_R {
    pub(crate) fn new(bits: u8) -> Self {
        OQPSK_DATA_RATE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> OQPSK_DATA_RATE_A {
        match self.bits {
            0 => OQPSK_DATA_RATE_A::RATE_250KB,
            1 => OQPSK_DATA_RATE_A::RATE_500KB,
            2 => OQPSK_DATA_RATE_A::RATE_1000KB,
            3 => OQPSK_DATA_RATE_A::RATE_2000KB,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `RATE_250KB`"]
    #[inline(always)]
    pub fn is_rate_250kb(&self) -> bool {
        **self == OQPSK_DATA_RATE_A::RATE_250KB
    }
    #[doc = "Checks if the value of the field is `RATE_500KB`"]
    #[inline(always)]
    pub fn is_rate_500kb(&self) -> bool {
        **self == OQPSK_DATA_RATE_A::RATE_500KB
    }
    #[doc = "Checks if the value of the field is `RATE_1000KB`"]
    #[inline(always)]
    pub fn is_rate_1000kb(&self) -> bool {
        **self == OQPSK_DATA_RATE_A::RATE_1000KB
    }
    #[doc = "Checks if the value of the field is `RATE_2000KB`"]
    #[inline(always)]
    pub fn is_rate_2000kb(&self) -> bool {
        **self == OQPSK_DATA_RATE_A::RATE_2000KB
    }
}
impl core::ops::Deref for OQPSK_DATA_RATE_R {
    type Target = crate::FieldReader<u8, OQPSK_DATA_RATE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OQPSK_DATA_RATE` writer - Data Rate Selection"]
pub struct OQPSK_DATA_RATE_W<'a> {
    w: &'a mut W,
}
impl<'a> OQPSK_DATA_RATE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OQPSK_DATA_RATE_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "250 kb/s (IEEE 802.15.4 compliant)"]
    #[inline(always)]
    pub fn rate_250kb(self) -> &'a mut W {
        self.variant(OQPSK_DATA_RATE_A::RATE_250KB)
    }
    #[doc = "500 kb/s"]
    #[inline(always)]
    pub fn rate_500kb(self) -> &'a mut W {
        self.variant(OQPSK_DATA_RATE_A::RATE_500KB)
    }
    #[doc = "1000 kb/s"]
    #[inline(always)]
    pub fn rate_1000kb(self) -> &'a mut W {
        self.variant(OQPSK_DATA_RATE_A::RATE_1000KB)
    }
    #[doc = "2000 kb/s"]
    #[inline(always)]
    pub fn rate_2000kb(self) -> &'a mut W {
        self.variant(OQPSK_DATA_RATE_A::RATE_2000KB)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 2)) | ((value as u8 & 0x1f) << 2);
        self.w
    }
}
#[doc = "Field `RX_SAFE_MODE` reader - RX Safe Mode"]
pub struct RX_SAFE_MODE_R(crate::FieldReader<bool, bool>);
impl RX_SAFE_MODE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_SAFE_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_SAFE_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_SAFE_MODE` writer - RX Safe Mode"]
pub struct RX_SAFE_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_SAFE_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Data Rate Selection"]
    #[inline(always)]
    pub fn oqpsk_data_rate(&self) -> OQPSK_DATA_RATE_R {
        OQPSK_DATA_RATE_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:6 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 2) & 0x1f) as u8)
    }
    #[doc = "Bit 7 - RX Safe Mode"]
    #[inline(always)]
    pub fn rx_safe_mode(&self) -> RX_SAFE_MODE_R {
        RX_SAFE_MODE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Data Rate Selection"]
    #[inline(always)]
    pub fn oqpsk_data_rate(&mut self) -> OQPSK_DATA_RATE_W {
        OQPSK_DATA_RATE_W { w: self }
    }
    #[doc = "Bits 2:6 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 7 - RX Safe Mode"]
    #[inline(always)]
    pub fn rx_safe_mode(&mut self) -> RX_SAFE_MODE_W {
        RX_SAFE_MODE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Control Register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [trx_ctrl_2](index.html) module"]
pub struct TRX_CTRL_2_SPEC;
impl crate::RegisterSpec for TRX_CTRL_2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [trx_ctrl_2::R](R) reader structure"]
impl crate::Readable for TRX_CTRL_2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [trx_ctrl_2::W](W) writer structure"]
impl crate::Writable for TRX_CTRL_2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TRX_CTRL_2 to value 0"]
impl crate::Resettable for TRX_CTRL_2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
