#[doc = "Register `TRX_CTRL_1` reader"]
pub struct R(crate::R<TRX_CTRL_1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TRX_CTRL_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TRX_CTRL_1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TRX_CTRL_1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TRX_CTRL_1` writer"]
pub struct W(crate::W<TRX_CTRL_1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TRX_CTRL_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TRX_CTRL_1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TRX_CTRL_1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u8 & 0x1f);
        self.w
    }
}
#[doc = "Field `TX_AUTO_CRC_ON` reader - Enable Automatic CRC Calculation"]
pub struct TX_AUTO_CRC_ON_R(crate::FieldReader<bool, bool>);
impl TX_AUTO_CRC_ON_R {
    pub(crate) fn new(bits: bool) -> Self {
        TX_AUTO_CRC_ON_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_AUTO_CRC_ON_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TX_AUTO_CRC_ON` writer - Enable Automatic CRC Calculation"]
pub struct TX_AUTO_CRC_ON_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_AUTO_CRC_ON_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `IRQ_2_EXT_EN` reader - Connect Frame Start IRQ to TC1"]
pub struct IRQ_2_EXT_EN_R(crate::FieldReader<bool, bool>);
impl IRQ_2_EXT_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRQ_2_EXT_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IRQ_2_EXT_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRQ_2_EXT_EN` writer - Connect Frame Start IRQ to TC1"]
pub struct IRQ_2_EXT_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> IRQ_2_EXT_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PA_EXT_EN` reader - External PA support enable"]
pub struct PA_EXT_EN_R(crate::FieldReader<bool, bool>);
impl PA_EXT_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        PA_EXT_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PA_EXT_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PA_EXT_EN` writer - External PA support enable"]
pub struct PA_EXT_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> PA_EXT_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bit 5 - Enable Automatic CRC Calculation"]
    #[inline(always)]
    pub fn tx_auto_crc_on(&self) -> TX_AUTO_CRC_ON_R {
        TX_AUTO_CRC_ON_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Connect Frame Start IRQ to TC1"]
    #[inline(always)]
    pub fn irq_2_ext_en(&self) -> IRQ_2_EXT_EN_R {
        IRQ_2_EXT_EN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - External PA support enable"]
    #[inline(always)]
    pub fn pa_ext_en(&self) -> PA_EXT_EN_R {
        PA_EXT_EN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:4 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 5 - Enable Automatic CRC Calculation"]
    #[inline(always)]
    pub fn tx_auto_crc_on(&mut self) -> TX_AUTO_CRC_ON_W {
        TX_AUTO_CRC_ON_W { w: self }
    }
    #[doc = "Bit 6 - Connect Frame Start IRQ to TC1"]
    #[inline(always)]
    pub fn irq_2_ext_en(&mut self) -> IRQ_2_EXT_EN_W {
        IRQ_2_EXT_EN_W { w: self }
    }
    #[doc = "Bit 7 - External PA support enable"]
    #[inline(always)]
    pub fn pa_ext_en(&mut self) -> PA_EXT_EN_W {
        PA_EXT_EN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Control Register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [trx_ctrl_1](index.html) module"]
pub struct TRX_CTRL_1_SPEC;
impl crate::RegisterSpec for TRX_CTRL_1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [trx_ctrl_1::R](R) reader structure"]
impl crate::Readable for TRX_CTRL_1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [trx_ctrl_1::W](W) writer structure"]
impl crate::Writable for TRX_CTRL_1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TRX_CTRL_1 to value 0"]
impl crate::Resettable for TRX_CTRL_1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
