#[doc = "Register `SFD_VALUE` reader"]
pub struct R(crate::R<SFD_VALUE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SFD_VALUE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SFD_VALUE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SFD_VALUE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SFD_VALUE` writer"]
pub struct W(crate::W<SFD_VALUE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SFD_VALUE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SFD_VALUE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SFD_VALUE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Start of Frame Delimiter Value\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SFD_VALUE_A {
    #[doc = "167: IEEE 802.15.4 compliant value of the SFD"]
    IEEE_SFD = 167,
}
impl From<SFD_VALUE_A> for u8 {
    #[inline(always)]
    fn from(variant: SFD_VALUE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SFD_VALUE` reader - Start of Frame Delimiter Value"]
pub struct SFD_VALUE_R(crate::FieldReader<u8, SFD_VALUE_A>);
impl SFD_VALUE_R {
    pub(crate) fn new(bits: u8) -> Self {
        SFD_VALUE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<SFD_VALUE_A> {
        match self.bits {
            167 => Some(SFD_VALUE_A::IEEE_SFD),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `IEEE_SFD`"]
    #[inline(always)]
    pub fn is_ieee_sfd(&self) -> bool {
        **self == SFD_VALUE_A::IEEE_SFD
    }
}
impl core::ops::Deref for SFD_VALUE_R {
    type Target = crate::FieldReader<u8, SFD_VALUE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFD_VALUE` writer - Start of Frame Delimiter Value"]
pub struct SFD_VALUE_W<'a> {
    w: &'a mut W,
}
impl<'a> SFD_VALUE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SFD_VALUE_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "IEEE 802.15.4 compliant value of the SFD"]
    #[inline(always)]
    pub fn ieee_sfd(self) -> &'a mut W {
        self.variant(SFD_VALUE_A::IEEE_SFD)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - Start of Frame Delimiter Value"]
    #[inline(always)]
    pub fn sfd_value(&self) -> SFD_VALUE_R {
        SFD_VALUE_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - Start of Frame Delimiter Value"]
    #[inline(always)]
    pub fn sfd_value(&mut self) -> SFD_VALUE_W {
        SFD_VALUE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Start of Frame Delimiter Value Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sfd_value](index.html) module"]
pub struct SFD_VALUE_SPEC;
impl crate::RegisterSpec for SFD_VALUE_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [sfd_value::R](R) reader structure"]
impl crate::Readable for SFD_VALUE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sfd_value::W](W) writer structure"]
impl crate::Writable for SFD_VALUE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SFD_VALUE to value 0"]
impl crate::Resettable for SFD_VALUE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
