#[doc = "Register `RX_SYN` reader"]
pub struct R(crate::R<RX_SYN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RX_SYN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RX_SYN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RX_SYN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RX_SYN` writer"]
pub struct W(crate::W<RX_SYN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RX_SYN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RX_SYN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RX_SYN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Reduce Receiver Sensitivity\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum RX_PDT_LEVEL_A {
    #[doc = "0: RX_THRES ≤ RSSI_BASE_VAL (Reset value); RSSI value not considered"]
    RX_PDT_LEVEL_MIN = 0,
    #[doc = "1: RX_THRES > RSSI_BASE_VAL + 0 · 3; RSSI > -90 dBm"]
    VAL_0X1 = 1,
    #[doc = "2: ..."]
    VAL_0X2 = 2,
    #[doc = "14: RX_THRES > RSSI_BASE_VAL + 13 · 3; RSSI > -51 dBm"]
    VAL_0XE = 14,
    #[doc = "15: RX_THRES > RSSI_BASE_VAL + 14 · 3; RSSI > -48 dBm"]
    RX_PDT_LEVEL_MAX = 15,
}
impl From<RX_PDT_LEVEL_A> for u8 {
    #[inline(always)]
    fn from(variant: RX_PDT_LEVEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `RX_PDT_LEVEL` reader - Reduce Receiver Sensitivity"]
pub struct RX_PDT_LEVEL_R(crate::FieldReader<u8, RX_PDT_LEVEL_A>);
impl RX_PDT_LEVEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        RX_PDT_LEVEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<RX_PDT_LEVEL_A> {
        match self.bits {
            0 => Some(RX_PDT_LEVEL_A::RX_PDT_LEVEL_MIN),
            1 => Some(RX_PDT_LEVEL_A::VAL_0X1),
            2 => Some(RX_PDT_LEVEL_A::VAL_0X2),
            14 => Some(RX_PDT_LEVEL_A::VAL_0XE),
            15 => Some(RX_PDT_LEVEL_A::RX_PDT_LEVEL_MAX),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `RX_PDT_LEVEL_MIN`"]
    #[inline(always)]
    pub fn is_rx_pdt_level_min(&self) -> bool {
        **self == RX_PDT_LEVEL_A::RX_PDT_LEVEL_MIN
    }
    #[doc = "Checks if the value of the field is `VAL_0X1`"]
    #[inline(always)]
    pub fn is_val_0x1(&self) -> bool {
        **self == RX_PDT_LEVEL_A::VAL_0X1
    }
    #[doc = "Checks if the value of the field is `VAL_0X2`"]
    #[inline(always)]
    pub fn is_val_0x2(&self) -> bool {
        **self == RX_PDT_LEVEL_A::VAL_0X2
    }
    #[doc = "Checks if the value of the field is `VAL_0XE`"]
    #[inline(always)]
    pub fn is_val_0x_e(&self) -> bool {
        **self == RX_PDT_LEVEL_A::VAL_0XE
    }
    #[doc = "Checks if the value of the field is `RX_PDT_LEVEL_MAX`"]
    #[inline(always)]
    pub fn is_rx_pdt_level_max(&self) -> bool {
        **self == RX_PDT_LEVEL_A::RX_PDT_LEVEL_MAX
    }
}
impl core::ops::Deref for RX_PDT_LEVEL_R {
    type Target = crate::FieldReader<u8, RX_PDT_LEVEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_PDT_LEVEL` writer - Reduce Receiver Sensitivity"]
pub struct RX_PDT_LEVEL_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_PDT_LEVEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: RX_PDT_LEVEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "RX_THRES ≤ RSSI_BASE_VAL (Reset value); RSSI value not considered"]
    #[inline(always)]
    pub fn rx_pdt_level_min(self) -> &'a mut W {
        self.variant(RX_PDT_LEVEL_A::RX_PDT_LEVEL_MIN)
    }
    #[doc = "RX_THRES > RSSI_BASE_VAL + 0 · 3; RSSI > -90 dBm"]
    #[inline(always)]
    pub fn val_0x1(self) -> &'a mut W {
        self.variant(RX_PDT_LEVEL_A::VAL_0X1)
    }
    #[doc = "..."]
    #[inline(always)]
    pub fn val_0x2(self) -> &'a mut W {
        self.variant(RX_PDT_LEVEL_A::VAL_0X2)
    }
    #[doc = "RX_THRES > RSSI_BASE_VAL + 13 · 3; RSSI > -51 dBm"]
    #[inline(always)]
    pub fn val_0x_e(self) -> &'a mut W {
        self.variant(RX_PDT_LEVEL_A::VAL_0XE)
    }
    #[doc = "RX_THRES > RSSI_BASE_VAL + 14 · 3; RSSI > -48 dBm"]
    #[inline(always)]
    pub fn rx_pdt_level_max(self) -> &'a mut W {
        self.variant(RX_PDT_LEVEL_A::RX_PDT_LEVEL_MAX)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 4)) | ((value as u8 & 0x07) << 4);
        self.w
    }
}
#[doc = "Field `RX_PDT_DIS` reader - Prevent Frame Reception"]
pub struct RX_PDT_DIS_R(crate::FieldReader<bool, bool>);
impl RX_PDT_DIS_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_PDT_DIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_PDT_DIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_PDT_DIS` writer - Prevent Frame Reception"]
pub struct RX_PDT_DIS_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_PDT_DIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Reduce Receiver Sensitivity"]
    #[inline(always)]
    pub fn rx_pdt_level(&self) -> RX_PDT_LEVEL_R {
        RX_PDT_LEVEL_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:6 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bit 7 - Prevent Frame Reception"]
    #[inline(always)]
    pub fn rx_pdt_dis(&self) -> RX_PDT_DIS_R {
        RX_PDT_DIS_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - Reduce Receiver Sensitivity"]
    #[inline(always)]
    pub fn rx_pdt_level(&mut self) -> RX_PDT_LEVEL_W {
        RX_PDT_LEVEL_W { w: self }
    }
    #[doc = "Bits 4:6 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 7 - Prevent Frame Reception"]
    #[inline(always)]
    pub fn rx_pdt_dis(&mut self) -> RX_PDT_DIS_W {
        RX_PDT_DIS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Receiver Sensitivity Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rx_syn](index.html) module"]
pub struct RX_SYN_SPEC;
impl crate::RegisterSpec for RX_SYN_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [rx_syn::R](R) reader structure"]
impl crate::Readable for RX_SYN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rx_syn::W](W) writer structure"]
impl crate::Writable for RX_SYN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RX_SYN to value 0"]
impl crate::Resettable for RX_SYN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
