#[doc = "Register `PHY_CC_CCA` reader"]
pub struct R(crate::R<PHY_CC_CCA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PHY_CC_CCA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PHY_CC_CCA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PHY_CC_CCA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PHY_CC_CCA` writer"]
pub struct W(crate::W<PHY_CC_CCA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PHY_CC_CCA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PHY_CC_CCA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PHY_CC_CCA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "RX/TX Channel Selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CHANNEL_A {
    #[doc = "11: 2405 MHz"]
    F_2405MHZ = 11,
    #[doc = "12: 2410 MHz"]
    F_2410MHZ = 12,
    #[doc = "13: 2415 MHz"]
    F_2415MHZ = 13,
    #[doc = "14: 2420 MHz"]
    F_2420MHZ = 14,
    #[doc = "15: 2425 MHz"]
    F_2425MHZ = 15,
    #[doc = "16: 2430 MHz"]
    F_2430MHZ = 16,
    #[doc = "17: 2435 MHz"]
    F_2435MHZ = 17,
    #[doc = "18: 2440 MHz"]
    F_2440MHZ = 18,
    #[doc = "19: 2445 MHz"]
    F_2445MHZ = 19,
    #[doc = "20: 2450 MHz"]
    F_2450MHZ = 20,
    #[doc = "21: 2455 MHz"]
    F_2455MHZ = 21,
    #[doc = "22: 2460 MHz"]
    F_2460MHZ = 22,
    #[doc = "23: 2465 MHz"]
    F_2465MHZ = 23,
    #[doc = "24: 2470 MHz"]
    F_2470MHZ = 24,
    #[doc = "25: 2475 MHz"]
    F_2475MHZ = 25,
    #[doc = "26: 2480 MHz"]
    F_2480MHZ = 26,
}
impl From<CHANNEL_A> for u8 {
    #[inline(always)]
    fn from(variant: CHANNEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CHANNEL` reader - RX/TX Channel Selection"]
pub struct CHANNEL_R(crate::FieldReader<u8, CHANNEL_A>);
impl CHANNEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CHANNEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CHANNEL_A> {
        match self.bits {
            11 => Some(CHANNEL_A::F_2405MHZ),
            12 => Some(CHANNEL_A::F_2410MHZ),
            13 => Some(CHANNEL_A::F_2415MHZ),
            14 => Some(CHANNEL_A::F_2420MHZ),
            15 => Some(CHANNEL_A::F_2425MHZ),
            16 => Some(CHANNEL_A::F_2430MHZ),
            17 => Some(CHANNEL_A::F_2435MHZ),
            18 => Some(CHANNEL_A::F_2440MHZ),
            19 => Some(CHANNEL_A::F_2445MHZ),
            20 => Some(CHANNEL_A::F_2450MHZ),
            21 => Some(CHANNEL_A::F_2455MHZ),
            22 => Some(CHANNEL_A::F_2460MHZ),
            23 => Some(CHANNEL_A::F_2465MHZ),
            24 => Some(CHANNEL_A::F_2470MHZ),
            25 => Some(CHANNEL_A::F_2475MHZ),
            26 => Some(CHANNEL_A::F_2480MHZ),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `F_2405MHZ`"]
    #[inline(always)]
    pub fn is_f_2405mhz(&self) -> bool {
        **self == CHANNEL_A::F_2405MHZ
    }
    #[doc = "Checks if the value of the field is `F_2410MHZ`"]
    #[inline(always)]
    pub fn is_f_2410mhz(&self) -> bool {
        **self == CHANNEL_A::F_2410MHZ
    }
    #[doc = "Checks if the value of the field is `F_2415MHZ`"]
    #[inline(always)]
    pub fn is_f_2415mhz(&self) -> bool {
        **self == CHANNEL_A::F_2415MHZ
    }
    #[doc = "Checks if the value of the field is `F_2420MHZ`"]
    #[inline(always)]
    pub fn is_f_2420mhz(&self) -> bool {
        **self == CHANNEL_A::F_2420MHZ
    }
    #[doc = "Checks if the value of the field is `F_2425MHZ`"]
    #[inline(always)]
    pub fn is_f_2425mhz(&self) -> bool {
        **self == CHANNEL_A::F_2425MHZ
    }
    #[doc = "Checks if the value of the field is `F_2430MHZ`"]
    #[inline(always)]
    pub fn is_f_2430mhz(&self) -> bool {
        **self == CHANNEL_A::F_2430MHZ
    }
    #[doc = "Checks if the value of the field is `F_2435MHZ`"]
    #[inline(always)]
    pub fn is_f_2435mhz(&self) -> bool {
        **self == CHANNEL_A::F_2435MHZ
    }
    #[doc = "Checks if the value of the field is `F_2440MHZ`"]
    #[inline(always)]
    pub fn is_f_2440mhz(&self) -> bool {
        **self == CHANNEL_A::F_2440MHZ
    }
    #[doc = "Checks if the value of the field is `F_2445MHZ`"]
    #[inline(always)]
    pub fn is_f_2445mhz(&self) -> bool {
        **self == CHANNEL_A::F_2445MHZ
    }
    #[doc = "Checks if the value of the field is `F_2450MHZ`"]
    #[inline(always)]
    pub fn is_f_2450mhz(&self) -> bool {
        **self == CHANNEL_A::F_2450MHZ
    }
    #[doc = "Checks if the value of the field is `F_2455MHZ`"]
    #[inline(always)]
    pub fn is_f_2455mhz(&self) -> bool {
        **self == CHANNEL_A::F_2455MHZ
    }
    #[doc = "Checks if the value of the field is `F_2460MHZ`"]
    #[inline(always)]
    pub fn is_f_2460mhz(&self) -> bool {
        **self == CHANNEL_A::F_2460MHZ
    }
    #[doc = "Checks if the value of the field is `F_2465MHZ`"]
    #[inline(always)]
    pub fn is_f_2465mhz(&self) -> bool {
        **self == CHANNEL_A::F_2465MHZ
    }
    #[doc = "Checks if the value of the field is `F_2470MHZ`"]
    #[inline(always)]
    pub fn is_f_2470mhz(&self) -> bool {
        **self == CHANNEL_A::F_2470MHZ
    }
    #[doc = "Checks if the value of the field is `F_2475MHZ`"]
    #[inline(always)]
    pub fn is_f_2475mhz(&self) -> bool {
        **self == CHANNEL_A::F_2475MHZ
    }
    #[doc = "Checks if the value of the field is `F_2480MHZ`"]
    #[inline(always)]
    pub fn is_f_2480mhz(&self) -> bool {
        **self == CHANNEL_A::F_2480MHZ
    }
}
impl core::ops::Deref for CHANNEL_R {
    type Target = crate::FieldReader<u8, CHANNEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CHANNEL` writer - RX/TX Channel Selection"]
pub struct CHANNEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CHANNEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CHANNEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "2405 MHz"]
    #[inline(always)]
    pub fn f_2405mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2405MHZ)
    }
    #[doc = "2410 MHz"]
    #[inline(always)]
    pub fn f_2410mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2410MHZ)
    }
    #[doc = "2415 MHz"]
    #[inline(always)]
    pub fn f_2415mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2415MHZ)
    }
    #[doc = "2420 MHz"]
    #[inline(always)]
    pub fn f_2420mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2420MHZ)
    }
    #[doc = "2425 MHz"]
    #[inline(always)]
    pub fn f_2425mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2425MHZ)
    }
    #[doc = "2430 MHz"]
    #[inline(always)]
    pub fn f_2430mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2430MHZ)
    }
    #[doc = "2435 MHz"]
    #[inline(always)]
    pub fn f_2435mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2435MHZ)
    }
    #[doc = "2440 MHz"]
    #[inline(always)]
    pub fn f_2440mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2440MHZ)
    }
    #[doc = "2445 MHz"]
    #[inline(always)]
    pub fn f_2445mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2445MHZ)
    }
    #[doc = "2450 MHz"]
    #[inline(always)]
    pub fn f_2450mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2450MHZ)
    }
    #[doc = "2455 MHz"]
    #[inline(always)]
    pub fn f_2455mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2455MHZ)
    }
    #[doc = "2460 MHz"]
    #[inline(always)]
    pub fn f_2460mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2460MHZ)
    }
    #[doc = "2465 MHz"]
    #[inline(always)]
    pub fn f_2465mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2465MHZ)
    }
    #[doc = "2470 MHz"]
    #[inline(always)]
    pub fn f_2470mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2470MHZ)
    }
    #[doc = "2475 MHz"]
    #[inline(always)]
    pub fn f_2475mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2475MHZ)
    }
    #[doc = "2480 MHz"]
    #[inline(always)]
    pub fn f_2480mhz(self) -> &'a mut W {
        self.variant(CHANNEL_A::F_2480MHZ)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u8 & 0x1f);
        self.w
    }
}
#[doc = "Select CCA Measurement Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CCA_MODE_A {
    #[doc = "0: Mode 3a, Carrier sense OR energy above threshold"]
    CCA_CS_OR_ED = 0,
    #[doc = "1: Mode 1, Energy above threshold"]
    CCA_ED = 1,
    #[doc = "2: Mode 2, Carrier sense only"]
    CCA_CS = 2,
    #[doc = "3: Mode 3b, Carrier sense AND energy above threshold"]
    CCA_CS_AND_ED = 3,
}
impl From<CCA_MODE_A> for u8 {
    #[inline(always)]
    fn from(variant: CCA_MODE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CCA_MODE` reader - Select CCA Measurement Mode"]
pub struct CCA_MODE_R(crate::FieldReader<u8, CCA_MODE_A>);
impl CCA_MODE_R {
    pub(crate) fn new(bits: u8) -> Self {
        CCA_MODE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CCA_MODE_A {
        match self.bits {
            0 => CCA_MODE_A::CCA_CS_OR_ED,
            1 => CCA_MODE_A::CCA_ED,
            2 => CCA_MODE_A::CCA_CS,
            3 => CCA_MODE_A::CCA_CS_AND_ED,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `CCA_CS_OR_ED`"]
    #[inline(always)]
    pub fn is_cca_cs_or_ed(&self) -> bool {
        **self == CCA_MODE_A::CCA_CS_OR_ED
    }
    #[doc = "Checks if the value of the field is `CCA_ED`"]
    #[inline(always)]
    pub fn is_cca_ed(&self) -> bool {
        **self == CCA_MODE_A::CCA_ED
    }
    #[doc = "Checks if the value of the field is `CCA_CS`"]
    #[inline(always)]
    pub fn is_cca_cs(&self) -> bool {
        **self == CCA_MODE_A::CCA_CS
    }
    #[doc = "Checks if the value of the field is `CCA_CS_AND_ED`"]
    #[inline(always)]
    pub fn is_cca_cs_and_ed(&self) -> bool {
        **self == CCA_MODE_A::CCA_CS_AND_ED
    }
}
impl core::ops::Deref for CCA_MODE_R {
    type Target = crate::FieldReader<u8, CCA_MODE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCA_MODE` writer - Select CCA Measurement Mode"]
pub struct CCA_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> CCA_MODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CCA_MODE_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Mode 3a, Carrier sense OR energy above threshold"]
    #[inline(always)]
    pub fn cca_cs_or_ed(self) -> &'a mut W {
        self.variant(CCA_MODE_A::CCA_CS_OR_ED)
    }
    #[doc = "Mode 1, Energy above threshold"]
    #[inline(always)]
    pub fn cca_ed(self) -> &'a mut W {
        self.variant(CCA_MODE_A::CCA_ED)
    }
    #[doc = "Mode 2, Carrier sense only"]
    #[inline(always)]
    pub fn cca_cs(self) -> &'a mut W {
        self.variant(CCA_MODE_A::CCA_CS)
    }
    #[doc = "Mode 3b, Carrier sense AND energy above threshold"]
    #[inline(always)]
    pub fn cca_cs_and_ed(self) -> &'a mut W {
        self.variant(CCA_MODE_A::CCA_CS_AND_ED)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 5)) | ((value as u8 & 0x03) << 5);
        self.w
    }
}
#[doc = "Field `CCA_REQUEST` reader - Manual CCA Measurement Request"]
pub struct CCA_REQUEST_R(crate::FieldReader<bool, bool>);
impl CCA_REQUEST_R {
    pub(crate) fn new(bits: bool) -> Self {
        CCA_REQUEST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCA_REQUEST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCA_REQUEST` writer - Manual CCA Measurement Request"]
pub struct CCA_REQUEST_W<'a> {
    w: &'a mut W,
}
impl<'a> CCA_REQUEST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - RX/TX Channel Selection"]
    #[inline(always)]
    pub fn channel(&self) -> CHANNEL_R {
        CHANNEL_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bits 5:6 - Select CCA Measurement Mode"]
    #[inline(always)]
    pub fn cca_mode(&self) -> CCA_MODE_R {
        CCA_MODE_R::new(((self.bits >> 5) & 0x03) as u8)
    }
    #[doc = "Bit 7 - Manual CCA Measurement Request"]
    #[inline(always)]
    pub fn cca_request(&self) -> CCA_REQUEST_R {
        CCA_REQUEST_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:4 - RX/TX Channel Selection"]
    #[inline(always)]
    pub fn channel(&mut self) -> CHANNEL_W {
        CHANNEL_W { w: self }
    }
    #[doc = "Bits 5:6 - Select CCA Measurement Mode"]
    #[inline(always)]
    pub fn cca_mode(&mut self) -> CCA_MODE_W {
        CCA_MODE_W { w: self }
    }
    #[doc = "Bit 7 - Manual CCA Measurement Request"]
    #[inline(always)]
    pub fn cca_request(&mut self) -> CCA_REQUEST_W {
        CCA_REQUEST_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Clear Channel Assessment (CCA) Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [phy_cc_cca](index.html) module"]
pub struct PHY_CC_CCA_SPEC;
impl crate::RegisterSpec for PHY_CC_CCA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [phy_cc_cca::R](R) reader structure"]
impl crate::Readable for PHY_CC_CCA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [phy_cc_cca::W](W) writer structure"]
impl crate::Writable for PHY_CC_CCA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PHY_CC_CCA to value 0"]
impl crate::Resettable for PHY_CC_CCA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
