#[doc = "Register `PAN_ID_1` reader"]
pub struct R(crate::R<PAN_ID_1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PAN_ID_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PAN_ID_1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PAN_ID_1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PAN_ID_1` writer"]
pub struct W(crate::W<PAN_ID_1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PAN_ID_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PAN_ID_1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PAN_ID_1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PAN_ID_` reader - MAC Personal Area Network ID"]
pub struct PAN_ID__R(crate::FieldReader<u8, u8>);
impl PAN_ID__R {
    pub(crate) fn new(bits: u8) -> Self {
        PAN_ID__R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PAN_ID__R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PAN_ID_` writer - MAC Personal Area Network ID"]
pub struct PAN_ID__W<'a> {
    w: &'a mut W,
}
impl<'a> PAN_ID__W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - MAC Personal Area Network ID"]
    #[inline(always)]
    pub fn pan_id_(&self) -> PAN_ID__R {
        PAN_ID__R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - MAC Personal Area Network ID"]
    #[inline(always)]
    pub fn pan_id_(&mut self) -> PAN_ID__W {
        PAN_ID__W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Personal Area Network ID Register (High Byte)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pan_id_1](index.html) module"]
pub struct PAN_ID_1_SPEC;
impl crate::RegisterSpec for PAN_ID_1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pan_id_1::R](R) reader structure"]
impl crate::Readable for PAN_ID_1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pan_id_1::W](W) writer structure"]
impl crate::Writable for PAN_ID_1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PAN_ID_1 to value 0"]
impl crate::Resettable for PAN_ID_1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
