#[doc = "Register `MAN_ID_1` reader"]
pub struct R(crate::R<MAN_ID_1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MAN_ID_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MAN_ID_1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MAN_ID_1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MAN_ID_1` writer"]
pub struct W(crate::W<MAN_ID_1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MAN_ID_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MAN_ID_1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MAN_ID_1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Manufacturer ID (High Byte)\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum MAN_ID__A {
    #[doc = "0: Atmel JEDEC manufacturer ID, bits \\[15:8\\]
of 32 bit manufacturer ID: 00 00 00 1F"]
    ATMEL_BYTE_1 = 0,
}
impl From<MAN_ID__A> for u8 {
    #[inline(always)]
    fn from(variant: MAN_ID__A) -> Self {
        variant as _
    }
}
#[doc = "Field `MAN_ID_` reader - Manufacturer ID (High Byte)"]
pub struct MAN_ID__R(crate::FieldReader<u8, MAN_ID__A>);
impl MAN_ID__R {
    pub(crate) fn new(bits: u8) -> Self {
        MAN_ID__R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<MAN_ID__A> {
        match self.bits {
            0 => Some(MAN_ID__A::ATMEL_BYTE_1),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ATMEL_BYTE_1`"]
    #[inline(always)]
    pub fn is_atmel_byte_1(&self) -> bool {
        **self == MAN_ID__A::ATMEL_BYTE_1
    }
}
impl core::ops::Deref for MAN_ID__R {
    type Target = crate::FieldReader<u8, MAN_ID__A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MAN_ID_` writer - Manufacturer ID (High Byte)"]
pub struct MAN_ID__W<'a> {
    w: &'a mut W,
}
impl<'a> MAN_ID__W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: MAN_ID__A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Atmel JEDEC manufacturer ID, bits \\[15:8\\]
of 32 bit manufacturer ID: 00 00 00 1F"]
    #[inline(always)]
    pub fn atmel_byte_1(self) -> &'a mut W {
        self.variant(MAN_ID__A::ATMEL_BYTE_1)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - Manufacturer ID (High Byte)"]
    #[inline(always)]
    pub fn man_id_(&self) -> MAN_ID__R {
        MAN_ID__R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - Manufacturer ID (High Byte)"]
    #[inline(always)]
    pub fn man_id_(&mut self) -> MAN_ID__W {
        MAN_ID__W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Device Identification Register (Manufacture ID High Byte)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [man_id_1](index.html) module"]
pub struct MAN_ID_1_SPEC;
impl crate::RegisterSpec for MAN_ID_1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [man_id_1::R](R) reader structure"]
impl crate::Readable for MAN_ID_1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [man_id_1::W](W) writer structure"]
impl crate::Writable for MAN_ID_1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MAN_ID_1 to value 0"]
impl crate::Resettable for MAN_ID_1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
