#[doc = "Register `IRQ_STATUS` reader"]
pub struct R(crate::R<IRQ_STATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<IRQ_STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<IRQ_STATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<IRQ_STATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `IRQ_STATUS` writer"]
pub struct W(crate::W<IRQ_STATUS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<IRQ_STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<IRQ_STATUS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<IRQ_STATUS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PLL_LOCK` reader - PLL Lock Interrupt Status"]
pub struct PLL_LOCK_R(crate::FieldReader<bool, bool>);
impl PLL_LOCK_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLL_LOCK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL_LOCK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL_LOCK` writer - PLL Lock Interrupt Status"]
pub struct PLL_LOCK_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL_LOCK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PLL_UNLOCK` reader - PLL Unlock Interrupt Status"]
pub struct PLL_UNLOCK_R(crate::FieldReader<bool, bool>);
impl PLL_UNLOCK_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLL_UNLOCK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL_UNLOCK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL_UNLOCK` writer - PLL Unlock Interrupt Status"]
pub struct PLL_UNLOCK_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL_UNLOCK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RX_START` reader - RX_START Interrupt Status"]
pub struct RX_START_R(crate::FieldReader<bool, bool>);
impl RX_START_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_START_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_START_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_START` writer - RX_START Interrupt Status"]
pub struct RX_START_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_START_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `RX_END` reader - RX_END Interrupt Status"]
pub struct RX_END_R(crate::FieldReader<bool, bool>);
impl RX_END_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_END_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_END_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_END` writer - RX_END Interrupt Status"]
pub struct RX_END_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_END_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `CCA_ED_DONE` reader - End of ED Measurement Interrupt Status"]
pub struct CCA_ED_DONE_R(crate::FieldReader<bool, bool>);
impl CCA_ED_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        CCA_ED_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCA_ED_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCA_ED_DONE` writer - End of ED Measurement Interrupt Status"]
pub struct CCA_ED_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> CCA_ED_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `AMI` reader - Address Match Interrupt Status"]
pub struct AMI_R(crate::FieldReader<bool, bool>);
impl AMI_R {
    pub(crate) fn new(bits: bool) -> Self {
        AMI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AMI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AMI` writer - Address Match Interrupt Status"]
pub struct AMI_W<'a> {
    w: &'a mut W,
}
impl<'a> AMI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TX_END` reader - TX_END Interrupt Status"]
pub struct TX_END_R(crate::FieldReader<bool, bool>);
impl TX_END_R {
    pub(crate) fn new(bits: bool) -> Self {
        TX_END_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_END_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TX_END` writer - TX_END Interrupt Status"]
pub struct TX_END_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_END_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `AWAKE` reader - Awake Interrupt Status"]
pub struct AWAKE_R(crate::FieldReader<bool, bool>);
impl AWAKE_R {
    pub(crate) fn new(bits: bool) -> Self {
        AWAKE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AWAKE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AWAKE` writer - Awake Interrupt Status"]
pub struct AWAKE_W<'a> {
    w: &'a mut W,
}
impl<'a> AWAKE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - PLL Lock Interrupt Status"]
    #[inline(always)]
    pub fn pll_lock(&self) -> PLL_LOCK_R {
        PLL_LOCK_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - PLL Unlock Interrupt Status"]
    #[inline(always)]
    pub fn pll_unlock(&self) -> PLL_UNLOCK_R {
        PLL_UNLOCK_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - RX_START Interrupt Status"]
    #[inline(always)]
    pub fn rx_start(&self) -> RX_START_R {
        RX_START_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - RX_END Interrupt Status"]
    #[inline(always)]
    pub fn rx_end(&self) -> RX_END_R {
        RX_END_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - End of ED Measurement Interrupt Status"]
    #[inline(always)]
    pub fn cca_ed_done(&self) -> CCA_ED_DONE_R {
        CCA_ED_DONE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Address Match Interrupt Status"]
    #[inline(always)]
    pub fn ami(&self) -> AMI_R {
        AMI_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX_END Interrupt Status"]
    #[inline(always)]
    pub fn tx_end(&self) -> TX_END_R {
        TX_END_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Awake Interrupt Status"]
    #[inline(always)]
    pub fn awake(&self) -> AWAKE_R {
        AWAKE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - PLL Lock Interrupt Status"]
    #[inline(always)]
    pub fn pll_lock(&mut self) -> PLL_LOCK_W {
        PLL_LOCK_W { w: self }
    }
    #[doc = "Bit 1 - PLL Unlock Interrupt Status"]
    #[inline(always)]
    pub fn pll_unlock(&mut self) -> PLL_UNLOCK_W {
        PLL_UNLOCK_W { w: self }
    }
    #[doc = "Bit 2 - RX_START Interrupt Status"]
    #[inline(always)]
    pub fn rx_start(&mut self) -> RX_START_W {
        RX_START_W { w: self }
    }
    #[doc = "Bit 3 - RX_END Interrupt Status"]
    #[inline(always)]
    pub fn rx_end(&mut self) -> RX_END_W {
        RX_END_W { w: self }
    }
    #[doc = "Bit 4 - End of ED Measurement Interrupt Status"]
    #[inline(always)]
    pub fn cca_ed_done(&mut self) -> CCA_ED_DONE_W {
        CCA_ED_DONE_W { w: self }
    }
    #[doc = "Bit 5 - Address Match Interrupt Status"]
    #[inline(always)]
    pub fn ami(&mut self) -> AMI_W {
        AMI_W { w: self }
    }
    #[doc = "Bit 6 - TX_END Interrupt Status"]
    #[inline(always)]
    pub fn tx_end(&mut self) -> TX_END_W {
        TX_END_W { w: self }
    }
    #[doc = "Bit 7 - Awake Interrupt Status"]
    #[inline(always)]
    pub fn awake(&mut self) -> AWAKE_W {
        AWAKE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Interrupt Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [irq_status](index.html) module"]
pub struct IRQ_STATUS_SPEC;
impl crate::RegisterSpec for IRQ_STATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [irq_status::R](R) reader structure"]
impl crate::Readable for IRQ_STATUS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [irq_status::W](W) writer structure"]
impl crate::Writable for IRQ_STATUS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets IRQ_STATUS to value 0"]
impl crate::Resettable for IRQ_STATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
