#[doc = "Register `IRQ_MASK` reader"]
pub struct R(crate::R<IRQ_MASK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<IRQ_MASK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<IRQ_MASK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<IRQ_MASK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `IRQ_MASK` writer"]
pub struct W(crate::W<IRQ_MASK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<IRQ_MASK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<IRQ_MASK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<IRQ_MASK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PLL_LOCK_EN` reader - PLL Lock Interrupt Enable"]
pub struct PLL_LOCK_EN_R(crate::FieldReader<bool, bool>);
impl PLL_LOCK_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLL_LOCK_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL_LOCK_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL_LOCK_EN` writer - PLL Lock Interrupt Enable"]
pub struct PLL_LOCK_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL_LOCK_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PLL_UNLOCK_EN` reader - PLL Unlock Interrupt Enable"]
pub struct PLL_UNLOCK_EN_R(crate::FieldReader<bool, bool>);
impl PLL_UNLOCK_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLL_UNLOCK_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLL_UNLOCK_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLL_UNLOCK_EN` writer - PLL Unlock Interrupt Enable"]
pub struct PLL_UNLOCK_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> PLL_UNLOCK_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RX_START_EN` reader - RX_START Interrupt Enable"]
pub struct RX_START_EN_R(crate::FieldReader<bool, bool>);
impl RX_START_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_START_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_START_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_START_EN` writer - RX_START Interrupt Enable"]
pub struct RX_START_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_START_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `RX_END_EN` reader - RX_END Interrupt Enable"]
pub struct RX_END_EN_R(crate::FieldReader<bool, bool>);
impl RX_END_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_END_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_END_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_END_EN` writer - RX_END Interrupt Enable"]
pub struct RX_END_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_END_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `CCA_ED_DONE_EN` reader - End of ED Measurement Interrupt Enable"]
pub struct CCA_ED_DONE_EN_R(crate::FieldReader<bool, bool>);
impl CCA_ED_DONE_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CCA_ED_DONE_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCA_ED_DONE_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCA_ED_DONE_EN` writer - End of ED Measurement Interrupt Enable"]
pub struct CCA_ED_DONE_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CCA_ED_DONE_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `AMI_EN` reader - Address Match Interrupt Enable"]
pub struct AMI_EN_R(crate::FieldReader<bool, bool>);
impl AMI_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        AMI_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AMI_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AMI_EN` writer - Address Match Interrupt Enable"]
pub struct AMI_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> AMI_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TX_END_EN` reader - TX_END Interrupt Enable"]
pub struct TX_END_EN_R(crate::FieldReader<bool, bool>);
impl TX_END_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TX_END_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_END_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TX_END_EN` writer - TX_END Interrupt Enable"]
pub struct TX_END_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_END_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `AWAKE_EN` reader - Awake Interrupt Enable"]
pub struct AWAKE_EN_R(crate::FieldReader<bool, bool>);
impl AWAKE_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        AWAKE_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AWAKE_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AWAKE_EN` writer - Awake Interrupt Enable"]
pub struct AWAKE_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> AWAKE_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - PLL Lock Interrupt Enable"]
    #[inline(always)]
    pub fn pll_lock_en(&self) -> PLL_LOCK_EN_R {
        PLL_LOCK_EN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - PLL Unlock Interrupt Enable"]
    #[inline(always)]
    pub fn pll_unlock_en(&self) -> PLL_UNLOCK_EN_R {
        PLL_UNLOCK_EN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - RX_START Interrupt Enable"]
    #[inline(always)]
    pub fn rx_start_en(&self) -> RX_START_EN_R {
        RX_START_EN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - RX_END Interrupt Enable"]
    #[inline(always)]
    pub fn rx_end_en(&self) -> RX_END_EN_R {
        RX_END_EN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - End of ED Measurement Interrupt Enable"]
    #[inline(always)]
    pub fn cca_ed_done_en(&self) -> CCA_ED_DONE_EN_R {
        CCA_ED_DONE_EN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Address Match Interrupt Enable"]
    #[inline(always)]
    pub fn ami_en(&self) -> AMI_EN_R {
        AMI_EN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX_END Interrupt Enable"]
    #[inline(always)]
    pub fn tx_end_en(&self) -> TX_END_EN_R {
        TX_END_EN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Awake Interrupt Enable"]
    #[inline(always)]
    pub fn awake_en(&self) -> AWAKE_EN_R {
        AWAKE_EN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - PLL Lock Interrupt Enable"]
    #[inline(always)]
    pub fn pll_lock_en(&mut self) -> PLL_LOCK_EN_W {
        PLL_LOCK_EN_W { w: self }
    }
    #[doc = "Bit 1 - PLL Unlock Interrupt Enable"]
    #[inline(always)]
    pub fn pll_unlock_en(&mut self) -> PLL_UNLOCK_EN_W {
        PLL_UNLOCK_EN_W { w: self }
    }
    #[doc = "Bit 2 - RX_START Interrupt Enable"]
    #[inline(always)]
    pub fn rx_start_en(&mut self) -> RX_START_EN_W {
        RX_START_EN_W { w: self }
    }
    #[doc = "Bit 3 - RX_END Interrupt Enable"]
    #[inline(always)]
    pub fn rx_end_en(&mut self) -> RX_END_EN_W {
        RX_END_EN_W { w: self }
    }
    #[doc = "Bit 4 - End of ED Measurement Interrupt Enable"]
    #[inline(always)]
    pub fn cca_ed_done_en(&mut self) -> CCA_ED_DONE_EN_W {
        CCA_ED_DONE_EN_W { w: self }
    }
    #[doc = "Bit 5 - Address Match Interrupt Enable"]
    #[inline(always)]
    pub fn ami_en(&mut self) -> AMI_EN_W {
        AMI_EN_W { w: self }
    }
    #[doc = "Bit 6 - TX_END Interrupt Enable"]
    #[inline(always)]
    pub fn tx_end_en(&mut self) -> TX_END_EN_W {
        TX_END_EN_W { w: self }
    }
    #[doc = "Bit 7 - Awake Interrupt Enable"]
    #[inline(always)]
    pub fn awake_en(&mut self) -> AWAKE_EN_W {
        AWAKE_EN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Interrupt Enable Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [irq_mask](index.html) module"]
pub struct IRQ_MASK_SPEC;
impl crate::RegisterSpec for IRQ_MASK_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [irq_mask::R](R) reader structure"]
impl crate::Readable for IRQ_MASK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [irq_mask::W](W) writer structure"]
impl crate::Writable for IRQ_MASK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets IRQ_MASK to value 0"]
impl crate::Resettable for IRQ_MASK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
