#[doc = "Register `FTN_CTRL` reader"]
pub struct R(crate::R<FTN_CTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FTN_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<FTN_CTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<FTN_CTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FTN_CTRL` writer"]
pub struct W(crate::W<FTN_CTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FTN_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<FTN_CTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<FTN_CTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FTN_START` reader - Start Calibration Loop of Filter Tuning Network"]
pub struct FTN_START_R(crate::FieldReader<bool, bool>);
impl FTN_START_R {
    pub(crate) fn new(bits: bool) -> Self {
        FTN_START_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FTN_START_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FTN_START` writer - Start Calibration Loop of Filter Tuning Network"]
pub struct FTN_START_W<'a> {
    w: &'a mut W,
}
impl<'a> FTN_START_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 7 - Start Calibration Loop of Filter Tuning Network"]
    #[inline(always)]
    pub fn ftn_start(&self) -> FTN_START_R {
        FTN_START_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 7 - Start Calibration Loop of Filter Tuning Network"]
    #[inline(always)]
    pub fn ftn_start(&mut self) -> FTN_START_W {
        FTN_START_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Filter Tuning Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ftn_ctrl](index.html) module"]
pub struct FTN_CTRL_SPEC;
impl crate::RegisterSpec for FTN_CTRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ftn_ctrl::R](R) reader structure"]
impl crate::Readable for FTN_CTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ftn_ctrl::W](W) writer structure"]
impl crate::Writable for FTN_CTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FTN_CTRL to value 0"]
impl crate::Resettable for FTN_CTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
