#[doc = "Register `CSMA_SEED_1` reader"]
pub struct R(crate::R<CSMA_SEED_1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CSMA_SEED_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CSMA_SEED_1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CSMA_SEED_1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CSMA_SEED_1` writer"]
pub struct W(crate::W<CSMA_SEED_1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CSMA_SEED_1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CSMA_SEED_1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CSMA_SEED_1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CSMA_SEED_1` reader - Seed Value for CSMA Random Number Generator"]
pub struct CSMA_SEED_1_R(crate::FieldReader<u8, u8>);
impl CSMA_SEED_1_R {
    pub(crate) fn new(bits: u8) -> Self {
        CSMA_SEED_1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CSMA_SEED_1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CSMA_SEED_1` writer - Seed Value for CSMA Random Number Generator"]
pub struct CSMA_SEED_1_W<'a> {
    w: &'a mut W,
}
impl<'a> CSMA_SEED_1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `AACK_I_AM_COORD` reader - Set Personal Area Network Coordinator"]
pub struct AACK_I_AM_COORD_R(crate::FieldReader<bool, bool>);
impl AACK_I_AM_COORD_R {
    pub(crate) fn new(bits: bool) -> Self {
        AACK_I_AM_COORD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AACK_I_AM_COORD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AACK_I_AM_COORD` writer - Set Personal Area Network Coordinator"]
pub struct AACK_I_AM_COORD_W<'a> {
    w: &'a mut W,
}
impl<'a> AACK_I_AM_COORD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `AACK_DIS_ACK` reader - Disable Acknowledgment Frame Transmission"]
pub struct AACK_DIS_ACK_R(crate::FieldReader<bool, bool>);
impl AACK_DIS_ACK_R {
    pub(crate) fn new(bits: bool) -> Self {
        AACK_DIS_ACK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AACK_DIS_ACK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AACK_DIS_ACK` writer - Disable Acknowledgment Frame Transmission"]
pub struct AACK_DIS_ACK_W<'a> {
    w: &'a mut W,
}
impl<'a> AACK_DIS_ACK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `AACK_SET_PD` reader - Set Frame Pending Sub-field"]
pub struct AACK_SET_PD_R(crate::FieldReader<bool, bool>);
impl AACK_SET_PD_R {
    pub(crate) fn new(bits: bool) -> Self {
        AACK_SET_PD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AACK_SET_PD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AACK_SET_PD` writer - Set Frame Pending Sub-field"]
pub struct AACK_SET_PD_W<'a> {
    w: &'a mut W,
}
impl<'a> AACK_SET_PD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Acknowledgment Frame Filter Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum AACK_FVN_MODE_A {
    #[doc = "0: Acknowledge frames with version number 0"]
    ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0 = 0,
    #[doc = "1: Acknowledge frames with version number 0 or 1"]
    ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1 = 1,
    #[doc = "2: Acknowledge frames with version number 0 or 1 or 2"]
    ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1_OR_2 = 2,
    #[doc = "3: Acknowledge frames independent of frame version number"]
    ACKNOWLEDGE_FRAMES_INDEPENDENT_OF_FRAME_VERSION_NUMBER = 3,
}
impl From<AACK_FVN_MODE_A> for u8 {
    #[inline(always)]
    fn from(variant: AACK_FVN_MODE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `AACK_FVN_MODE` reader - Acknowledgment Frame Filter Mode"]
pub struct AACK_FVN_MODE_R(crate::FieldReader<u8, AACK_FVN_MODE_A>);
impl AACK_FVN_MODE_R {
    pub(crate) fn new(bits: u8) -> Self {
        AACK_FVN_MODE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AACK_FVN_MODE_A {
        match self.bits {
            0 => AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0,
            1 => AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1,
            2 => AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1_OR_2,
            3 => AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_INDEPENDENT_OF_FRAME_VERSION_NUMBER,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0`"]
    #[inline(always)]
    pub fn is_acknowledge_frames_with_version_number_0(&self) -> bool {
        **self == AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0
    }
    #[doc = "Checks if the value of the field is `ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1`"]
    #[inline(always)]
    pub fn is_acknowledge_frames_with_version_number_0_or_1(&self) -> bool {
        **self == AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1
    }
    #[doc = "Checks if the value of the field is `ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1_OR_2`"]
    #[inline(always)]
    pub fn is_acknowledge_frames_with_version_number_0_or_1_or_2(&self) -> bool {
        **self == AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1_OR_2
    }
    #[doc = "Checks if the value of the field is `ACKNOWLEDGE_FRAMES_INDEPENDENT_OF_FRAME_VERSION_NUMBER`"]
    #[inline(always)]
    pub fn is_acknowledge_frames_independent_of_frame_version_number(&self) -> bool {
        **self == AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_INDEPENDENT_OF_FRAME_VERSION_NUMBER
    }
}
impl core::ops::Deref for AACK_FVN_MODE_R {
    type Target = crate::FieldReader<u8, AACK_FVN_MODE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AACK_FVN_MODE` writer - Acknowledgment Frame Filter Mode"]
pub struct AACK_FVN_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> AACK_FVN_MODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AACK_FVN_MODE_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Acknowledge frames with version number 0"]
    #[inline(always)]
    pub fn acknowledge_frames_with_version_number_0(self) -> &'a mut W {
        self.variant(AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0)
    }
    #[doc = "Acknowledge frames with version number 0 or 1"]
    #[inline(always)]
    pub fn acknowledge_frames_with_version_number_0_or_1(self) -> &'a mut W {
        self.variant(AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1)
    }
    #[doc = "Acknowledge frames with version number 0 or 1 or 2"]
    #[inline(always)]
    pub fn acknowledge_frames_with_version_number_0_or_1_or_2(self) -> &'a mut W {
        self.variant(AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_WITH_VERSION_NUMBER_0_OR_1_OR_2)
    }
    #[doc = "Acknowledge frames independent of frame version number"]
    #[inline(always)]
    pub fn acknowledge_frames_independent_of_frame_version_number(self) -> &'a mut W {
        self.variant(AACK_FVN_MODE_A::ACKNOWLEDGE_FRAMES_INDEPENDENT_OF_FRAME_VERSION_NUMBER)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Seed Value for CSMA Random Number Generator"]
    #[inline(always)]
    pub fn csma_seed_1(&self) -> CSMA_SEED_1_R {
        CSMA_SEED_1_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Set Personal Area Network Coordinator"]
    #[inline(always)]
    pub fn aack_i_am_coord(&self) -> AACK_I_AM_COORD_R {
        AACK_I_AM_COORD_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Disable Acknowledgment Frame Transmission"]
    #[inline(always)]
    pub fn aack_dis_ack(&self) -> AACK_DIS_ACK_R {
        AACK_DIS_ACK_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Set Frame Pending Sub-field"]
    #[inline(always)]
    pub fn aack_set_pd(&self) -> AACK_SET_PD_R {
        AACK_SET_PD_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bits 6:7 - Acknowledgment Frame Filter Mode"]
    #[inline(always)]
    pub fn aack_fvn_mode(&self) -> AACK_FVN_MODE_R {
        AACK_FVN_MODE_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Seed Value for CSMA Random Number Generator"]
    #[inline(always)]
    pub fn csma_seed_1(&mut self) -> CSMA_SEED_1_W {
        CSMA_SEED_1_W { w: self }
    }
    #[doc = "Bit 3 - Set Personal Area Network Coordinator"]
    #[inline(always)]
    pub fn aack_i_am_coord(&mut self) -> AACK_I_AM_COORD_W {
        AACK_I_AM_COORD_W { w: self }
    }
    #[doc = "Bit 4 - Disable Acknowledgment Frame Transmission"]
    #[inline(always)]
    pub fn aack_dis_ack(&mut self) -> AACK_DIS_ACK_W {
        AACK_DIS_ACK_W { w: self }
    }
    #[doc = "Bit 5 - Set Frame Pending Sub-field"]
    #[inline(always)]
    pub fn aack_set_pd(&mut self) -> AACK_SET_PD_W {
        AACK_SET_PD_W { w: self }
    }
    #[doc = "Bits 6:7 - Acknowledgment Frame Filter Mode"]
    #[inline(always)]
    pub fn aack_fvn_mode(&mut self) -> AACK_FVN_MODE_W {
        AACK_FVN_MODE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver Acknowledgment Frame Control Register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [csma_seed_1](index.html) module"]
pub struct CSMA_SEED_1_SPEC;
impl crate::RegisterSpec for CSMA_SEED_1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [csma_seed_1::R](R) reader structure"]
impl crate::Readable for CSMA_SEED_1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [csma_seed_1::W](W) writer structure"]
impl crate::Writable for CSMA_SEED_1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CSMA_SEED_1 to value 0"]
impl crate::Resettable for CSMA_SEED_1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
