#[doc = "Register `CCA_THRES` reader"]
pub struct R(crate::R<CCA_THRES_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CCA_THRES_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CCA_THRES_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CCA_THRES_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CCA_THRES` writer"]
pub struct W(crate::W<CCA_THRES_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CCA_THRES_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CCA_THRES_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CCA_THRES_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CCA_ED_THRES` reader - ED Threshold Level for CCA Measurement"]
pub struct CCA_ED_THRES_R(crate::FieldReader<u8, u8>);
impl CCA_ED_THRES_R {
    pub(crate) fn new(bits: u8) -> Self {
        CCA_ED_THRES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCA_ED_THRES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCA_ED_THRES` writer - ED Threshold Level for CCA Measurement"]
pub struct CCA_ED_THRES_W<'a> {
    w: &'a mut W,
}
impl<'a> CCA_ED_THRES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `CCA_CS_THRES` reader - CS Threshold Level for CCA Measurement"]
pub struct CCA_CS_THRES_R(crate::FieldReader<u8, u8>);
impl CCA_CS_THRES_R {
    pub(crate) fn new(bits: u8) -> Self {
        CCA_CS_THRES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCA_CS_THRES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCA_CS_THRES` writer - CS Threshold Level for CCA Measurement"]
pub struct CCA_CS_THRES_W<'a> {
    w: &'a mut W,
}
impl<'a> CCA_CS_THRES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u8 & 0x0f) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - ED Threshold Level for CCA Measurement"]
    #[inline(always)]
    pub fn cca_ed_thres(&self) -> CCA_ED_THRES_R {
        CCA_ED_THRES_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - CS Threshold Level for CCA Measurement"]
    #[inline(always)]
    pub fn cca_cs_thres(&self) -> CCA_CS_THRES_R {
        CCA_CS_THRES_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:3 - ED Threshold Level for CCA Measurement"]
    #[inline(always)]
    pub fn cca_ed_thres(&mut self) -> CCA_ED_THRES_W {
        CCA_ED_THRES_W { w: self }
    }
    #[doc = "Bits 4:7 - CS Threshold Level for CCA Measurement"]
    #[inline(always)]
    pub fn cca_cs_thres(&mut self) -> CCA_CS_THRES_W {
        CCA_CS_THRES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Transceiver CCA Threshold Setting Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cca_thres](index.html) module"]
pub struct CCA_THRES_SPEC;
impl crate::RegisterSpec for CCA_THRES_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [cca_thres::R](R) reader structure"]
impl crate::Readable for CCA_THRES_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cca_thres::W](W) writer structure"]
impl crate::Writable for CCA_THRES_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CCA_THRES to value 0"]
impl crate::Resettable for CCA_THRES_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
