#[doc = "Register `AES_STATUS` reader"]
pub struct R(crate::R<AES_STATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AES_STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<AES_STATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<AES_STATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AES_STATUS` writer"]
pub struct W(crate::W<AES_STATUS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AES_STATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<AES_STATUS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<AES_STATUS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `AES_DONE` reader - AES Operation Finished with Success"]
pub struct AES_DONE_R(crate::FieldReader<bool, bool>);
impl AES_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        AES_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AES_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_DONE` writer - AES Operation Finished with Success"]
pub struct AES_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 1)) | ((value as u8 & 0x3f) << 1);
        self.w
    }
}
#[doc = "Field `AES_ER` reader - AES Operation Finished with Error"]
pub struct AES_ER_R(crate::FieldReader<bool, bool>);
impl AES_ER_R {
    pub(crate) fn new(bits: bool) -> Self {
        AES_ER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AES_ER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_ER` writer - AES Operation Finished with Error"]
pub struct AES_ER_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_ER_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - AES Operation Finished with Success"]
    #[inline(always)]
    pub fn aes_done(&self) -> AES_DONE_R {
        AES_DONE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:6 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new(((self.bits >> 1) & 0x3f) as u8)
    }
    #[doc = "Bit 7 - AES Operation Finished with Error"]
    #[inline(always)]
    pub fn aes_er(&self) -> AES_ER_R {
        AES_ER_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - AES Operation Finished with Success"]
    #[inline(always)]
    pub fn aes_done(&mut self) -> AES_DONE_W {
        AES_DONE_W { w: self }
    }
    #[doc = "Bits 1:6 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 7 - AES Operation Finished with Error"]
    #[inline(always)]
    pub fn aes_er(&mut self) -> AES_ER_W {
        AES_ER_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AES Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [aes_status](index.html) module"]
pub struct AES_STATUS_SPEC;
impl crate::RegisterSpec for AES_STATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [aes_status::R](R) reader structure"]
impl crate::Readable for AES_STATUS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [aes_status::W](W) writer structure"]
impl crate::Writable for AES_STATUS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AES_STATUS to value 0"]
impl crate::Resettable for AES_STATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
