#[doc = "Register `AES_KEY` reader"]
pub struct R(crate::R<AES_KEY_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AES_KEY_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<AES_KEY_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<AES_KEY_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AES_KEY` writer"]
pub struct W(crate::W<AES_KEY_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AES_KEY_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<AES_KEY_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<AES_KEY_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `AES_KEY` reader - AES Encryption/Decryption Key Buffer"]
pub struct AES_KEY_R(crate::FieldReader<u8, u8>);
impl AES_KEY_R {
    pub(crate) fn new(bits: u8) -> Self {
        AES_KEY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AES_KEY_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_KEY` writer - AES Encryption/Decryption Key Buffer"]
pub struct AES_KEY_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_KEY_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - AES Encryption/Decryption Key Buffer"]
    #[inline(always)]
    pub fn aes_key(&self) -> AES_KEY_R {
        AES_KEY_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - AES Encryption/Decryption Key Buffer"]
    #[inline(always)]
    pub fn aes_key(&mut self) -> AES_KEY_W {
        AES_KEY_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AES Encryption and Decryption Key Buffer Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [aes_key](index.html) module"]
pub struct AES_KEY_SPEC;
impl crate::RegisterSpec for AES_KEY_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [aes_key::R](R) reader structure"]
impl crate::Readable for AES_KEY_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [aes_key::W](W) writer structure"]
impl crate::Writable for AES_KEY_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AES_KEY to value 0"]
impl crate::Resettable for AES_KEY_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
