#[doc = "Register `AES_CTRL` reader"]
pub struct R(crate::R<AES_CTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AES_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<AES_CTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<AES_CTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AES_CTRL` writer"]
pub struct W(crate::W<AES_CTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AES_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<AES_CTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<AES_CTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `AES_IM` reader - AES Interrupt Enable"]
pub struct AES_IM_R(crate::FieldReader<bool, bool>);
impl AES_IM_R {
    pub(crate) fn new(bits: bool) -> Self {
        AES_IM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AES_IM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_IM` writer - AES Interrupt Enable"]
pub struct AES_IM_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_IM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Set AES Operation Direction\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum AES_DIR_A {
    #[doc = "0: AES operation is encryption."]
    AES_DIR_ENC = 0,
    #[doc = "1: AES operation is decryption."]
    AES_DIR_DEC = 1,
}
impl From<AES_DIR_A> for bool {
    #[inline(always)]
    fn from(variant: AES_DIR_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `AES_DIR` reader - Set AES Operation Direction"]
pub struct AES_DIR_R(crate::FieldReader<bool, AES_DIR_A>);
impl AES_DIR_R {
    pub(crate) fn new(bits: bool) -> Self {
        AES_DIR_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AES_DIR_A {
        match self.bits {
            false => AES_DIR_A::AES_DIR_ENC,
            true => AES_DIR_A::AES_DIR_DEC,
        }
    }
    #[doc = "Checks if the value of the field is `AES_DIR_ENC`"]
    #[inline(always)]
    pub fn is_aes_dir_enc(&self) -> bool {
        **self == AES_DIR_A::AES_DIR_ENC
    }
    #[doc = "Checks if the value of the field is `AES_DIR_DEC`"]
    #[inline(always)]
    pub fn is_aes_dir_dec(&self) -> bool {
        **self == AES_DIR_A::AES_DIR_DEC
    }
}
impl core::ops::Deref for AES_DIR_R {
    type Target = crate::FieldReader<bool, AES_DIR_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_DIR` writer - Set AES Operation Direction"]
pub struct AES_DIR_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_DIR_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AES_DIR_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "AES operation is encryption."]
    #[inline(always)]
    pub fn aes_dir_enc(self) -> &'a mut W {
        self.variant(AES_DIR_A::AES_DIR_ENC)
    }
    #[doc = "AES operation is decryption."]
    #[inline(always)]
    pub fn aes_dir_dec(self) -> &'a mut W {
        self.variant(AES_DIR_A::AES_DIR_DEC)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Set AES Operation Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum AES_MODE_A {
    #[doc = "0: AES Mode is ECB (Electronic Code Book)."]
    AES_MODE_ECB = 0,
    #[doc = "1: AES Mode is CBC (Cipher Block Chaining)."]
    AES_MODE_CBC = 1,
}
impl From<AES_MODE_A> for bool {
    #[inline(always)]
    fn from(variant: AES_MODE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `AES_MODE` reader - Set AES Operation Mode"]
pub struct AES_MODE_R(crate::FieldReader<bool, AES_MODE_A>);
impl AES_MODE_R {
    pub(crate) fn new(bits: bool) -> Self {
        AES_MODE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AES_MODE_A {
        match self.bits {
            false => AES_MODE_A::AES_MODE_ECB,
            true => AES_MODE_A::AES_MODE_CBC,
        }
    }
    #[doc = "Checks if the value of the field is `AES_MODE_ECB`"]
    #[inline(always)]
    pub fn is_aes_mode_ecb(&self) -> bool {
        **self == AES_MODE_A::AES_MODE_ECB
    }
    #[doc = "Checks if the value of the field is `AES_MODE_CBC`"]
    #[inline(always)]
    pub fn is_aes_mode_cbc(&self) -> bool {
        **self == AES_MODE_A::AES_MODE_CBC
    }
}
impl core::ops::Deref for AES_MODE_R {
    type Target = crate::FieldReader<bool, AES_MODE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_MODE` writer - Set AES Operation Mode"]
pub struct AES_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_MODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AES_MODE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "AES Mode is ECB (Electronic Code Book)."]
    #[inline(always)]
    pub fn aes_mode_ecb(self) -> &'a mut W {
        self.variant(AES_MODE_A::AES_MODE_ECB)
    }
    #[doc = "AES Mode is CBC (Cipher Block Chaining)."]
    #[inline(always)]
    pub fn aes_mode_cbc(self) -> &'a mut W {
        self.variant(AES_MODE_A::AES_MODE_CBC)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `AES_REQUEST` reader - Request AES Operation."]
pub struct AES_REQUEST_R(crate::FieldReader<bool, bool>);
impl AES_REQUEST_R {
    pub(crate) fn new(bits: bool) -> Self {
        AES_REQUEST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AES_REQUEST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_REQUEST` writer - Request AES Operation."]
pub struct AES_REQUEST_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_REQUEST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - AES Interrupt Enable"]
    #[inline(always)]
    pub fn aes_im(&self) -> AES_IM_R {
        AES_IM_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Set AES Operation Direction"]
    #[inline(always)]
    pub fn aes_dir(&self) -> AES_DIR_R {
        AES_DIR_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Set AES Operation Mode"]
    #[inline(always)]
    pub fn aes_mode(&self) -> AES_MODE_R {
        AES_MODE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Request AES Operation."]
    #[inline(always)]
    pub fn aes_request(&self) -> AES_REQUEST_R {
        AES_REQUEST_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - AES Interrupt Enable"]
    #[inline(always)]
    pub fn aes_im(&mut self) -> AES_IM_W {
        AES_IM_W { w: self }
    }
    #[doc = "Bit 3 - Set AES Operation Direction"]
    #[inline(always)]
    pub fn aes_dir(&mut self) -> AES_DIR_W {
        AES_DIR_W { w: self }
    }
    #[doc = "Bit 5 - Set AES Operation Mode"]
    #[inline(always)]
    pub fn aes_mode(&mut self) -> AES_MODE_W {
        AES_MODE_W { w: self }
    }
    #[doc = "Bit 7 - Request AES Operation."]
    #[inline(always)]
    pub fn aes_request(&mut self) -> AES_REQUEST_W {
        AES_REQUEST_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AES Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [aes_ctrl](index.html) module"]
pub struct AES_CTRL_SPEC;
impl crate::RegisterSpec for AES_CTRL_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [aes_ctrl::R](R) reader structure"]
impl crate::Readable for AES_CTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [aes_ctrl::W](W) writer structure"]
impl crate::Writable for AES_CTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AES_CTRL to value 0"]
impl crate::Resettable for AES_CTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
