#[doc = "Register `TCCR5C` reader"]
pub struct R(crate::R<TCCR5C_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR5C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR5C_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR5C_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR5C` writer"]
pub struct W(crate::W<TCCR5C_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR5C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR5C_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR5C_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `Res` reader - Reserved"]
pub struct RES_R(crate::FieldReader<u8, u8>);
impl RES_R {
    pub(crate) fn new(bits: u8) -> Self {
        RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Res` writer - Reserved"]
pub struct RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u8 & 0x1f);
        self.w
    }
}
#[doc = "Field `FOC5C` reader - Force Output Compare for Channel C"]
pub struct FOC5C_R(crate::FieldReader<bool, bool>);
impl FOC5C_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC5C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC5C_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC5C` writer - Force Output Compare for Channel C"]
pub struct FOC5C_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC5C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `FOC5B` reader - Force Output Compare for Channel B"]
pub struct FOC5B_R(crate::FieldReader<bool, bool>);
impl FOC5B_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC5B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC5B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC5B` writer - Force Output Compare for Channel B"]
pub struct FOC5B_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC5B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FOC5A` reader - Force Output Compare for Channel A"]
pub struct FOC5A_R(crate::FieldReader<bool, bool>);
impl FOC5A_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC5A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC5A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC5A` writer - Force Output Compare for Channel A"]
pub struct FOC5A_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC5A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - Reserved"]
    #[inline(always)]
    pub fn res(&self) -> RES_R {
        RES_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bit 5 - Force Output Compare for Channel C"]
    #[inline(always)]
    pub fn foc5c(&self) -> FOC5C_R {
        FOC5C_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Force Output Compare for Channel B"]
    #[inline(always)]
    pub fn foc5b(&self) -> FOC5B_R {
        FOC5B_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Force Output Compare for Channel A"]
    #[inline(always)]
    pub fn foc5a(&self) -> FOC5A_R {
        FOC5A_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:4 - Reserved"]
    #[inline(always)]
    pub fn res(&mut self) -> RES_W {
        RES_W { w: self }
    }
    #[doc = "Bit 5 - Force Output Compare for Channel C"]
    #[inline(always)]
    pub fn foc5c(&mut self) -> FOC5C_W {
        FOC5C_W { w: self }
    }
    #[doc = "Bit 6 - Force Output Compare for Channel B"]
    #[inline(always)]
    pub fn foc5b(&mut self) -> FOC5B_W {
        FOC5B_W { w: self }
    }
    #[doc = "Bit 7 - Force Output Compare for Channel A"]
    #[inline(always)]
    pub fn foc5a(&mut self) -> FOC5A_W {
        FOC5A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter5 Control Register C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr5c](index.html) module"]
pub struct TCCR5C_SPEC;
impl crate::RegisterSpec for TCCR5C_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr5c::R](R) reader structure"]
impl crate::Readable for TCCR5C_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr5c::W](W) writer structure"]
impl crate::Writable for TCCR5C_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR5C to value 0"]
impl crate::Resettable for TCCR5C_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
